/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.codegenerate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MethodCodegen {
    private final String name;
    private List<String> body = Lists.newArrayList();
    private String protectedValue = "public";
    private String returnValue = "void";
    private Set<ArgValue> argValues = Sets.newLinkedHashSet();

    public MethodCodegen(String name) {
        this.name = name;
    }

    public MethodCodegen addBody(String Body) {
        this.body.add(Body);
        return this;
    }

    public String getProtectedValue() {
        return this.protectedValue;
    }

    public MethodCodegen setProtectedValue(String protectedValue) {
        this.protectedValue = protectedValue;
        return this;
    }

    public String getReturnValue() {
        return this.returnValue;
    }

    public MethodCodegen setReturnValue(String returnValue) {
        this.returnValue = returnValue;
        return this;
    }

    public MethodCodegen add(String declarType, String declarName) {
        ArgValue argValue = new ArgValue();
        argValue.declarName = declarName;
        argValue.declarType = declarType;
        this.argValues.add(argValue);
        return this;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String args = this.argValues.stream().map(Object::toString).collect(Collectors.joining(","));
        buffer.append(String.format("    %s %s %s(%s) {\n", this.protectedValue, this.returnValue, this.name, args));
        this.body.forEach(i -> buffer.append(i + "\n"));
        buffer.append("    }\n");
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodCodegen)) {
            return false;
        }
        MethodCodegen other = (MethodCodegen)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$body = this.body;
        List<String> other$body = other.body;
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        String this$protectedValue = this.getProtectedValue();
        String other$protectedValue = other.getProtectedValue();
        if (this$protectedValue == null ? other$protectedValue != null : !this$protectedValue.equals(other$protectedValue)) {
            return false;
        }
        String this$returnValue = this.getReturnValue();
        String other$returnValue = other.getReturnValue();
        return !(this$returnValue == null ? other$returnValue != null : !this$returnValue.equals(other$returnValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MethodCodegen;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $body = this.body;
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        String $protectedValue = this.getProtectedValue();
        result = result * 59 + ($protectedValue == null ? 43 : $protectedValue.hashCode());
        String $returnValue = this.getReturnValue();
        result = result * 59 + ($returnValue == null ? 43 : $returnValue.hashCode());
        return result;
    }

    class ArgValue {
        String declarType;
        String declarName;

        ArgValue() {
        }

        public String toString() {
            return this.declarType + " " + this.declarName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArgValue)) {
                return false;
            }
            ArgValue other = (ArgValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$declarType = this.declarType;
            String other$declarType = other.declarType;
            if (this$declarType == null ? other$declarType != null : !this$declarType.equals(other$declarType)) {
                return false;
            }
            String this$declarName = this.declarName;
            String other$declarName = other.declarName;
            return !(this$declarName == null ? other$declarName != null : !this$declarName.equals(other$declarName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ArgValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $declarType = this.declarType;
            result = result * 59 + ($declarType == null ? 43 : $declarType.hashCode());
            String $declarName = this.declarName;
            result = result * 59 + ($declarName == null ? 43 : $declarName.hashCode());
            return result;
        }
    }
}

