/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.concurrent;

import io.github.h800572003.concurrent.IQueue;
import io.github.h800572003.concurrent.IWorkPool;
import io.github.h800572003.concurrent.WorkAdpaterCallBackend;
import io.github.h800572003.concurrent.WorkExecutor;
import io.github.h800572003.exception.ApBusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class AlwAysAliveWorkPool<T>
implements IWorkPool {
    private static final Logger log = LoggerFactory.getLogger(AlwAysAliveWorkPool.class);
    private List<Work> works = new ArrayList<Work>();
    private final int workSize;
    private final ExecutorService executorService;
    private volatile ThreadFactory threadFactory;
    private final IQueue<T> queue;
    private final WorkExecutor<T> workExecutor;
    private final WorkAdpaterCallBackend<T> workAdpaterCallBackend;
    private final CountDownLatch workDownLatch;
    private final String name;
    private boolean isStart = false;

    public AlwAysAliveWorkPool(int workSize, String name, IQueue<T> queue, WorkExecutor<T> workExecutor, WorkAdpaterCallBackend<T> workAdpaterCallBackend) {
        this.workSize = workSize;
        this.threadFactory = new CustomizableThreadFactory(name);
        this.executorService = Executors.newFixedThreadPool(workSize, this.threadFactory);
        this.queue = queue;
        this.name = name;
        this.workExecutor = workExecutor;
        this.workAdpaterCallBackend = workAdpaterCallBackend;
        this.workDownLatch = new CountDownLatch(workSize);
    }

    @Override
    public synchronized void start() {
        if (this.isStart) {
            throw new ApBusinessException("\u670d\u52d9\u5df2\u555f\u52d5", new Object[0]);
        }
        IntStream.range(0, this.workSize).forEach(i -> this.works.add(this.createWork(i)));
        this.isStart = true;
    }

    protected Work createWork(int index) {
        return new Work(this.queue, this.name + "_" + index, this.workExecutor);
    }

    @Override
    public void close() {
        this.executorService.shutdownNow();
        try {
            this.workDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public class Work {
        private final IQueue<T> queue;
        private Future<?> submit;
        private final WorkExecutor<T> workExecutor;

        public Work(IQueue<T> queue, String name, WorkExecutor<T> workExecutor) {
            this.queue = queue;
            this.workExecutor = workExecutor;
            this.submit = AlwAysAliveWorkPool.this.executorService.submit(() -> {
                while (!Thread.currentThread().isInterrupted()) {
                    Object t = null;
                    try {
                        t = this.queue.take();
                        this.execute(t);
                    }
                    catch (InterruptedException e) {
                        log.info("\u56de\u6536\u5de5\u4eba");
                        break;
                    }
                    finally {
                        if (t == null) continue;
                        this.queue.remove(t);
                    }
                }
                AlwAysAliveWorkPool.this.workDownLatch.countDown();
            });
        }

        public void stop() {
            this.submit.cancel(true);
        }

        protected void execute(T t) {
            block2: {
                try {
                    this.workExecutor.execute(t);
                    AlwAysAliveWorkPool.this.workAdpaterCallBackend.call(t, null);
                }
                catch (Exception e) {
                    if (AlwAysAliveWorkPool.this.workAdpaterCallBackend == null) break block2;
                    AlwAysAliveWorkPool.this.workAdpaterCallBackend.call(t, e);
                }
            }
        }
    }
}

