/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.concurrent;

import com.google.common.collect.Lists;
import io.github.h800572003.concurrent.IQueue;
import java.util.LinkedList;

public class BlockQueue<T>
implements IQueue<T> {
    private final int blockSize;
    private final LinkedList<T> items = Lists.newLinkedList();

    public BlockQueue(int blockSize) {
        this.blockSize = blockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(T item) {
        LinkedList<T> linkedList = this.items;
        synchronized (linkedList) {
            while (this.items.size() > this.blockSize) {
                try {
                    this.items.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            this.items.addLast(item);
            this.items.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T take() throws InterruptedException {
        LinkedList<T> linkedList = this.items;
        synchronized (linkedList) {
            while (this.items.isEmpty()) {
                this.items.wait();
            }
            return this.items.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        LinkedList<T> linkedList = this.items;
        synchronized (linkedList) {
            return this.items.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        LinkedList<T> linkedList = this.items;
        synchronized (linkedList) {
            return this.items.size();
        }
    }

    @Override
    public void remove(T src) {
    }
}

