/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.concurrent;

import com.google.common.collect.Lists;
import io.github.h800572003.concurrent.IQueue;
import io.github.h800572003.concurrent.IWorkPool;
import io.github.h800572003.concurrent.WorkAdpaterCallBackend;
import io.github.h800572003.concurrent.WorkExecutor;
import io.github.h800572003.exception.ApBusinessException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class CountDownLatchWorkPool<T>
implements IWorkPool {
    private static final Logger log = LoggerFactory.getLogger(CountDownLatchWorkPool.class);
    private List<Work> works = null;
    private final CountDownLatch countDownLatch;
    private final CountDownLatch workDownLatch;
    private final IQueue<T> queue;
    private final WorkExecutor<T> workExecutor;
    private final String name;
    private final WorkAdpaterCallBackend<T> workAdpaterCallBackend;
    private final int workSize;
    private final ExecutorService executorService;
    private volatile ThreadFactory threadFactory;

    public CountDownLatchWorkPool(String name, int workSize, WorkExecutor<T> workExecutor, CountDownLatch countDownLatch, IQueue<T> queue, WorkAdpaterCallBackend<T> workAdpaterCallBackend) {
        this.threadFactory = new CustomizableThreadFactory(name);
        this.name = name;
        this.workExecutor = workExecutor;
        this.countDownLatch = countDownLatch;
        this.queue = queue;
        this.workSize = workSize;
        this.workDownLatch = new CountDownLatch(workSize);
        this.workAdpaterCallBackend = workAdpaterCallBackend;
        this.executorService = Executors.newFixedThreadPool(workSize, this.threadFactory);
    }

    @Override
    public synchronized void start() {
        if (this.works != null) {
            throw new ApBusinessException("\u670d\u52d9\u5df2\u555f\u52d5", new Object[0]);
        }
        this.works = Lists.newArrayList();
        IntStream.range(0, this.workSize).forEach(i -> this.works.add(this.createWork(i)));
    }

    protected Work createWork(int index) {
        return new Work(this.queue, this.name + "_" + index, this.workExecutor);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
        if (!this.executorService.isTerminated()) {
            List<Runnable> shutdownNow = this.executorService.shutdownNow();
            log.info("shutdownNow size:{}", (Object)shutdownNow.size());
        }
        try {
            this.workDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public class Work {
        private final IQueue<T> queue;
        private Future<?> submit;
        private final WorkExecutor<T> workExecutor;

        public Work(IQueue<T> queue, String name, WorkExecutor<T> workExecutor) {
            this.queue = queue;
            this.workExecutor = workExecutor;
            this.submit = CountDownLatchWorkPool.this.executorService.submit(() -> {
                while (!Thread.currentThread().isInterrupted()) {
                    Object t = null;
                    try {
                        t = this.queue.take();
                        this.execute(t);
                    }
                    catch (InterruptedException e) {
                        log.info("\u56de\u6536\u5de5\u4eba");
                        break;
                    }
                    finally {
                        if (t != null) {
                            this.queue.remove(t);
                        }
                        CountDownLatchWorkPool.this.countDownLatch.countDown();
                    }
                }
                CountDownLatchWorkPool.this.workDownLatch.countDown();
            });
        }

        protected void execute(T t) {
            block2: {
                try {
                    this.workExecutor.execute(t);
                    CountDownLatchWorkPool.this.workAdpaterCallBackend.call(t, null);
                }
                catch (Exception e) {
                    if (CountDownLatchWorkPool.this.workAdpaterCallBackend == null) break block2;
                    CountDownLatchWorkPool.this.workAdpaterCallBackend.call(t, e);
                }
            }
        }

        public void stop() {
            this.submit.cancel(true);
        }
    }
}

