/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.concurrent;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.github.h800572003.concurrent.IGetNoService;
import io.github.h800572003.exception.ApBusinessException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GetNoServiceInMem
implements IGetNoService {
    private LoadingCache<String, AtomicInteger> loadingCache;

    public GetNoServiceInMem(GetNoServiceCofog cofog) {
        this.loadingCache = CacheBuilder.newBuilder().maximumSize((long)cofog.cacheSize).expireAfterAccess((long)cofog.expireAfterAccess, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, AtomicInteger>(){

            public AtomicInteger load(String key) throws Exception {
                return new AtomicInteger();
            }
        });
    }

    public GetNoServiceInMem() {
        this(new GetNoServiceCofog());
    }

    @Override
    public synchronized String getNo(String key, int size) {
        String format = key + "%0" + size + "d";
        try {
            AtomicInteger i = (AtomicInteger)this.loadingCache.get((Object)key);
            return String.format(format, i.incrementAndGet());
        }
        catch (ExecutionException e) {
            return String.format(format, 0);
        }
    }

    static class GetNoServiceCofog {
        int expireAfterAccess = 60;
        int cacheSize = 1000;
        int initNo = 0;

        GetNoServiceCofog() {
        }

        public void setExpireAfterAccess(int expireAfterAccess) {
            if (expireAfterAccess <= 0) {
                throw new ApBusinessException("must be greater than 0", new Object[0]);
            }
            this.expireAfterAccess = expireAfterAccess;
        }

        public void setCacheSize(int cacheSize) {
            if (this.expireAfterAccess <= 0) {
                throw new ApBusinessException("must be greater than 0", new Object[0]);
            }
            this.cacheSize = cacheSize;
        }

        public void setInitNo(int initNo) {
            if (this.expireAfterAccess <= 0) {
                throw new ApBusinessException("must be greater than 0", new Object[0]);
            }
            this.initNo = initNo;
        }
    }
}

