/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ObjectDownLatch {
    private List<Object> list = new ArrayList<Object>();
    private Map<Object, AtomicInteger> downMap;

    public ObjectDownLatch(List<?> list) {
        this.list.addAll(list);
        this.downMap = this.list.stream().collect(Collectors.toMap(i -> i, i -> new AtomicInteger(-1)));
    }

    public synchronized void await() throws InterruptedException {
        while (!this.list.isEmpty()) {
            this.wait();
        }
    }

    public synchronized void remove(Object object, int size) {
        if (this.downMap.containsKey(object)) {
            AtomicInteger atomicInteger = this.downMap.get(object);
            if (atomicInteger.get() == -1) {
                atomicInteger = new AtomicInteger(size);
                this.downMap.put(object, atomicInteger);
            }
            if (atomicInteger.get() > 0) {
                int decrementAndGet = atomicInteger.decrementAndGet();
                this.downMap.put(object, atomicInteger);
                if (decrementAndGet == 0) {
                    this.list.remove(object);
                    if (this.list.isEmpty()) {
                        this.notifyAll();
                    }
                }
            }
        }
    }
}

