/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.concurrent;

import com.google.common.collect.Lists;
import io.github.h800572003.concurrent.IBlockKey;
import io.github.h800572003.concurrent.IOrderKeyQueue;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;

public class OrderQueue<T extends IBlockKey>
implements IOrderKeyQueue<T> {
    private final LinkedList<T> waitPool = Lists.newLinkedList();
    private final LinkedList<T> cachePool = Lists.newLinkedList();
    private final Set<String> waitPoolSet = new HashSet<String>();
    private final Object mute = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(T t) {
        Object object = this.mute;
        synchronized (object) {
            if (!this.isKeyInWait(t)) {
                this.waitPool.addLast(t);
                this.waitPoolSet.add(t.toKey());
            } else {
                this.cachePool.addLast(t);
            }
            this.mute.notifyAll();
        }
    }

    private boolean isKeyInWait(T key) {
        return this.waitPoolSet.contains(key.toKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T take() throws InterruptedException {
        Object object = this.mute;
        synchronized (object) {
            while (this.waitPool.isEmpty()) {
                this.mute.wait();
            }
            try {
                IBlockKey removeFirst = (IBlockKey)this.waitPool.removeFirst();
                return (T)removeFirst;
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBlock(T key) {
        Object object = this.mute;
        synchronized (object) {
            this.waitPoolSet.remove(key.toKey());
            Iterator it = this.cachePool.iterator();
            while (it.hasNext()) {
                IBlockKey next = (IBlockKey)it.next();
                if (this.isKeyInWait(next)) continue;
                this.addWaitPool(next);
                it.remove();
            }
            this.mute.notifyAll();
        }
    }

    private void addWaitPool(T t) {
        this.waitPool.addLast(t);
        this.waitPoolSet.add(t.toKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.mute;
        synchronized (object) {
            return this.cachePool.isEmpty() && this.waitPoolSet.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.mute;
        synchronized (object) {
            return this.waitPool.size() + this.cachePool.size();
        }
    }

    @Override
    public void remove(T src) {
        this.removeBlock(src);
    }
}

