/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.concurrent;

import io.github.h800572003.concurrent.BlockQueue;
import io.github.h800572003.concurrent.CountDownLatchWorkPool;
import io.github.h800572003.concurrent.IQueue;
import io.github.h800572003.concurrent.IWorkPool;
import io.github.h800572003.concurrent.IWorkService;
import io.github.h800572003.concurrent.WorkAdpaterCallBackend;
import io.github.h800572003.concurrent.WorkExecutor;
import io.github.h800572003.exception.ApBusinessException;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkLatchService<T>
implements Closeable,
IWorkService<T> {
    private static final Logger log = LoggerFactory.getLogger(WorkLatchService.class);
    private CountDownLatch countDownLatch;
    protected final WorkExecutor<T> workExecutor;
    protected final WorkAdpaterCallBackend<T> workAdpaterCallBackend;
    protected final String prefName;
    protected final int workSize;
    protected IWorkPool workPool;

    public static <T> WorkLatchService<T> newService(String prefName, IQueue<T> queue, int workSize, WorkExecutor<T> workListener, WorkAdpaterCallBackend<T> workAdpaterCallBackend) {
        return new WorkLatchService<T>(prefName, workSize, workListener, workAdpaterCallBackend);
    }

    protected WorkLatchService(String prefName, int workSize, WorkExecutor<T> workListener, WorkAdpaterCallBackend<T> workAdpaterCallBackend) {
        this.prefName = prefName;
        this.workExecutor = workListener;
        this.workAdpaterCallBackend = workAdpaterCallBackend;
        this.workSize = workSize;
    }

    @Override
    public void close() {
        this.workPool.close();
        log.debug("close down");
    }

    @Override
    public void execute(IQueue<T> queue, List<? extends T> items) throws InterruptedException {
        if (this.countDownLatch != null) {
            throw new ApBusinessException("\u6bcf\u6b21\u50c5\u6b64\u57f7\u884c\u4e00\u6b21", new Object[0]);
        }
        this.countDownLatch = new CountDownLatch(items.size());
        items.forEach(i -> queue.add(i));
        this.workPool = this.createPool(queue);
        this.workPool.start();
        this.countDownLatch.await();
        log.debug("item down done");
    }

    protected IWorkPool createPool(IQueue<T> queue) {
        CountDownLatchWorkPool<T> workPool = new CountDownLatchWorkPool<T>(this.prefName, this.workSize, this.workExecutor, this.countDownLatch, queue, this.workAdpaterCallBackend);
        return workPool;
    }

    @Override
    public void execute(List<? extends T> items) throws InterruptedException {
        this.execute(new BlockQueue(100), items);
    }
}

