/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.date;

import io.github.h800572003.exception.ApBusinessException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DateUtlis {
    static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy/MM/dd HH:mm:ss";
    public static final String YYYMMDD = "yyyyMMdd";

    public static boolean afterNow(Date date, int type, int amount) {
        Calendar statTime = Calendar.getInstance();
        statTime.setTimeInMillis(date.getTime());
        statTime.add(type, amount);
        return statTime.getTime().after(new Date());
    }

    public static LocalDateTime paresrNullEqaulNow(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return LocalDateTime.now();
        }
        return LocalDateTime.parse(value, formatter);
    }

    public static String getText() {
        return DateUtlis.getText(YYYY_MM_DD_HH_MM_SS, new Date());
    }

    public static String getText(String format, Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(date);
    }

    public static Date parse(String yyyymmdd) {
        return DateUtlis.parse("yyyy/MM/dd", yyyymmdd);
    }

    public static Date parse(String format, String yyyymmdd) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
            return simpleDateFormat.parse(yyyymmdd);
        }
        catch (ParseException var2) {
            throw new ApBusinessException("\u65e5\u671f\u683c\u5f0f\u932f\u8aa4:" + yyyymmdd, new Object[0]);
        }
    }

    public static String today() {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern(YYYMMDD);
        Date date = new Date();
        return sdf.format(date);
    }
}

