/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.event.deiven;

import com.google.common.collect.Maps;
import io.github.h800572003.countdown.CountDown;
import io.github.h800572003.event.deiven.IChannel;
import io.github.h800572003.event.deiven.IMessage;
import io.github.h800572003.event.deiven.IMultDynamicRouter;
import io.github.h800572003.exception.ApBusinessException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class AsynDynamicRouter
implements IMultDynamicRouter<IMessage>,
AutoCloseable {
    private ExecutorService executor;
    private CountDown countDown;
    private Map<Class<? extends IMessage>, IChannel> map = Maps.newConcurrentMap();

    public AsynDynamicRouter(ExecutorService executor) {
        this.executor = executor;
        this.countDown = new CountDown();
    }

    public AsynDynamicRouter(String name, int size) {
        this(Executors.newScheduledThreadPool(size, (ThreadFactory)new CustomizableThreadFactory(name)));
    }

    @Override
    public void registerChannel(Class<? extends IMessage> messageType, IChannel<? extends IMessage> channel) {
        this.map.put(messageType, channel);
    }

    @Override
    public <T2 extends IMessage> void dispatch(T2 message) {
        if (!this.map.containsKey(message.getClass())) {
            throw new ApBusinessException("not match channel:{0}", message);
        }
        IChannel iChannel = this.map.get(message.getClass());
        this.executor.submit(() -> {
            this.countDown.increase();
            try {
                iChannel.dispatch(message);
            }
            finally {
                this.countDown.decrease();
            }
        });
    }

    @Override
    public void close() {
        this.executor.shutdown();
        try {
            this.countDown.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

