/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.eventbuus;

import com.google.common.collect.Lists;
import io.github.h800572003.eventbuus.FileChangeEvent;
import io.github.h800572003.eventbuus.IBus;
import io.github.h800572003.eventbuus.IDirMonitor;
import io.github.h800572003.exception.ApBusinessException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirMonitor
implements IDirMonitor {
    private static final Logger log = LoggerFactory.getLogger(DirMonitor.class);
    private WatchService service;
    private final IBus eventBus;
    private final Path path;
    private volatile boolean start = true;
    List<WatchEvent.Kind<?>> eventsList = Lists.newArrayList();

    public DirMonitor(IBus eventBus, String targe) {
        this.eventBus = eventBus;
        this.path = Paths.get(targe, new String[0]);
    }

    @Override
    public void startMonitor(WatchEvent.Kind<?> ... events) throws IOException {
        if (this.service != null) {
            throw new ApBusinessException("\u670d\u52d9\u5df2\u555f\u52d5", new Object[0]);
        }
        this.addEventList(events);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                log.info("Shutdown");
                this.service.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }));
        this.service = FileSystems.getDefault().newWatchService();
        this.path.register(this.service, this.eventsList.toArray(new WatchEvent.Kind[this.eventsList.size()]));
        while (!Thread.currentThread().isInterrupted()) {
            try {
                WatchKey take = this.service.take();
                List<WatchEvent<?>> pollEvents = take.pollEvents();
                pollEvents.forEach(e -> {
                    Path path = (Path)e.context();
                    WatchEvent.Kind kind = e.kind();
                    Path resolve = this.path.resolve(path);
                    this.eventBus.post(new FileChangeEvent(resolve, kind));
                });
                if (take.reset()) continue;
                log.info("exit watch server");
            }
            catch (InterruptedException e1) {
                this.start = false;
                log.info("\u4e2d\u65b7\u4f5c\u696d");
            }
        }
        log.info("close..");
    }

    private void addEventList(WatchEvent.Kind<?> ... events) {
        if (events.length == 0) {
            this.eventsList.add(StandardWatchEventKinds.ENTRY_CREATE);
            this.eventsList.add(StandardWatchEventKinds.ENTRY_DELETE);
            this.eventsList.add(StandardWatchEventKinds.ENTRY_MODIFY);
            this.eventsList.add(StandardWatchEventKinds.OVERFLOW);
        } else {
            Stream.of(events).forEach(this.eventsList::add);
        }
    }

    @Override
    public void close() throws IOException {
        this.start = false;
    }
}

