/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.eventbuus;

import io.github.h800572003.eventbuus.EventExceptionxHandler;
import io.github.h800572003.eventbuus.IBus;
import io.github.h800572003.eventbuus.Registry;
import io.github.h800572003.eventbuus.Subscriber;
import java.lang.reflect.InvocationTargetException;
import java.util.Queue;
import java.util.concurrent.ExecutorService;

public class Dispatchar {
    private final ExecutorService executor;
    private final EventExceptionxHandler eventExceptionxhandler;
    private final IBus bus;
    private final Registry registry;

    public Dispatchar(IBus bus, Registry registry, ExecutorService executor, EventExceptionxHandler eventExceptionxhandler) {
        this.executor = executor;
        this.eventExceptionxhandler = eventExceptionxhandler;
        this.bus = bus;
        this.registry = registry;
    }

    public void dispatch(String topic, Object event) {
        Queue<Subscriber> subscribers = this.registry.getQueueByTopic(topic);
        if (subscribers == null) {
            if (this.eventExceptionxhandler != null) {
                this.eventExceptionxhandler.handle("\u7121\u8a02\u95b1\u8005");
            }
        } else {
            subscribers.stream().filter(i -> {
                Class<?> class1 = i.getMethod().getParameterTypes()[0];
                return class1.isAssignableFrom(event.getClass());
            }).forEach(i -> this.invoke(this.bus, (Subscriber)i, event));
        }
    }

    public void invoke(IBus busm, Subscriber subscriber, Object event) {
        this.executor.execute(() -> {
            block2: {
                try {
                    subscriber.getMethod().invoke(subscriber.getSubscriber(), event);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    if (this.eventExceptionxhandler == null) break block2;
                    this.eventExceptionxhandler.handle("invoke error:" + event.getClass().getName(), e);
                }
            }
        });
    }

    public void close() {
        if (this.executor != null && this.executor.isShutdown()) {
            this.executor.shutdown();
        }
    }
}

