/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.eventbuus;

import io.github.h800572003.eventbuus.Dispatchar;
import io.github.h800572003.eventbuus.EventExceptionxHandler;
import io.github.h800572003.eventbuus.IBus;
import io.github.h800572003.eventbuus.Registry;
import io.github.h800572003.exception.ApBusinessException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class EventBus
implements IBus {
    private final Registry registry;
    private final Dispatchar dispatchar;
    private String busName;

    public EventBus(String busName, ExecutorService executor) {
        this(busName, executor, new ApEventExceptionxHandler());
    }

    public EventBus(String busName) {
        this(busName, 1);
    }

    public EventBus(String busName, int size) {
        this(busName, Executors.newFixedThreadPool(size, (ThreadFactory)new CustomizableThreadFactory(busName)));
    }

    public EventBus(String busName, EventExceptionxHandler eventExceptionxhandler, int size) {
        this(busName, Executors.newFixedThreadPool(size, (ThreadFactory)new CustomizableThreadFactory(busName)), eventExceptionxhandler);
    }

    public EventBus(String busName, ExecutorService executor, EventExceptionxHandler eventExceptionxhandler) {
        this.busName = busName;
        this.registry = new Registry();
        this.dispatchar = new Dispatchar(this, this.registry, executor, eventExceptionxhandler);
    }

    @Override
    public void register(Object subscriber) {
        this.registry.bind(subscriber);
    }

    @Override
    public void unRegister(Object subscriber) {
        this.registry.ubbind(subscriber);
    }

    @Override
    public void post(Object evnet) {
        this.dispatchar.dispatch("default-topic", evnet);
    }

    @Override
    public void post(Object evnet, String topic) {
        this.dispatchar.dispatch(topic, evnet);
    }

    @Override
    public void close() {
        this.dispatchar.close();
    }

    @Override
    public String getBusName() {
        return this.busName;
    }

    private static class ApEventExceptionxHandler
    implements EventExceptionxHandler {
        private ApEventExceptionxHandler() {
        }

        @Override
        public void handle(String message) {
            throw new ApBusinessException(message, new Object[0]);
        }

        @Override
        public void handle(String message, Exception e) {
            throw new ApBusinessException(message, e);
        }
    }
}

