/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.eventbuus;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.h800572003.eventbuus.Subscribe;
import io.github.h800572003.eventbuus.Subscriber;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;

public class Registry {
    Map<String, Queue<Subscriber>> map = Maps.newConcurrentMap();

    void bind(Object subscriber) {
        List<Method> methods = this.findMethods(subscriber);
        methods.forEach(m -> this.tirerSubcruber(subscriber, (Method)m));
    }

    private List<Method> findMethods(Object subscriber) {
        ArrayList methods = Lists.newArrayList();
        Method[] declaredMethods = subscriber.getClass().getDeclaredMethods();
        Stream.of(declaredMethods).filter(i -> i.isAnnotationPresent(Subscribe.class) && i.getParameterCount() == 1 && i.getModifiers() == 1).forEach(methods::add);
        return methods;
    }

    void ubbind(Object subscriber) {
    }

    public void tirerSubcruber(Object subscriber, Method method) {
        Subscribe subscribe = method.getDeclaredAnnotation(Subscribe.class);
        String topic = subscribe.topic();
        this.map.computeIfAbsent(topic, key -> new ConcurrentLinkedQueue());
        this.map.get(topic).add(new Subscriber(subscriber, method));
    }

    public Queue<Subscriber> getQueueByTopic(String topic) {
        return this.map.get(topic);
    }
}

