/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.log;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.OptionHelper;
import io.github.h800572003.properties.Code;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.LoggerFactory;

public class LogbackConfig {
    private final Map<String, String> packageNameMap = new HashMap<String, String>();
    private final Set<String> set = new HashSet<String>();
    private final List<Code> codes = new ArrayList<Code>();
    private boolean additive = false;

    public void setAdditive(boolean additive) {
        this.additive = additive;
    }

    public void registerPackage(String code, String name, Class<?> pClass) {
        this.register(code, name, true, pClass);
    }

    public void registerSlef(String code, String name, Class<?> pClass) {
        this.register(code, name, false, pClass);
    }

    public void register(String code, String name, boolean isPackage, Class<?> pClass) {
        if (pClass != null) {
            String packageName = isPackage ? pClass.getPackage().getName() : pClass.getName();
            this.packageNameMap.put(code, packageName);
        }
        Code myCode = new Code();
        myCode.setKey(code);
        myCode.setValue(name);
        this.codes.add(myCode);
        this.set.add(code);
    }

    public void setup() {
        for (Map.Entry<String, String> entry : this.packageNameMap.entrySet()) {
            this.appender(entry.getKey(), entry.getValue(), this.additive);
        }
    }

    private void appender(String name, String pClass, boolean additive) {
        Logger log = (Logger)LoggerFactory.getLogger((String)pClass);
        log.setAdditive(additive);
        LoggerContext loggerContext = log.getLoggerContext();
        log.addAppender(this.createAppender(name, loggerContext));
    }

    private RollingFileAppender<ILoggingEvent> createAppender(String name, LoggerContext loggerContext) {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setContext((Context)loggerContext);
        appender.setName(name);
        String logPath = OptionHelper.substVars((String)("${logPath}" + name + "/" + name + ".log"), (PropertyContainer)loggerContext);
        appender.setFile(logPath);
        appender.setAppend(true);
        appender.setPrudent(false);
        appender.setRollingPolicy(this.createRollingPolicy(name, loggerContext, (FileAppender<ILoggingEvent>)appender));
        appender.setEncoder((Encoder)this.createEncoder(loggerContext));
        appender.start();
        return appender;
    }

    private PatternLayoutEncoder createEncoder(LoggerContext context) {
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)context);
        String pattern = OptionHelper.substVars((String)"${pattern}", (PropertyContainer)context);
        encoder.setPattern(pattern);
        encoder.setCharset(Charset.forName("utf-8"));
        encoder.start();
        return encoder;
    }

    private TimeBasedRollingPolicy<Object> createRollingPolicy(String name, LoggerContext context, FileAppender<ILoggingEvent> appender) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("${logPath}");
        stringBuilder.append(name);
        stringBuilder.append("/");
        stringBuilder.append(name);
        stringBuilder.append(".%d{yyyy-MM-dd}.%i.log");
        String fp = OptionHelper.substVars((String)stringBuilder.toString(), (PropertyContainer)context);
        TimeBasedRollingPolicy rollingPolicyBase = new TimeBasedRollingPolicy();
        rollingPolicyBase.setContext((Context)context);
        rollingPolicyBase.setParent(appender);
        rollingPolicyBase.setFileNamePattern(fp);
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize(FileSize.valueOf((String)OptionHelper.substVars((String)"${max.file.size}", (PropertyContainer)context)));
        rollingPolicyBase.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)sizeAndTimeBasedFNATP);
        rollingPolicyBase.setMaxHistory(Integer.parseInt(OptionHelper.substVars((String)"${max.history}", (PropertyContainer)context)));
        rollingPolicyBase.setTotalSizeCap(FileSize.valueOf((String)OptionHelper.substVars((String)"${total.size.cap}", (PropertyContainer)context)));
        rollingPolicyBase.start();
        return rollingPolicyBase;
    }

    public File getByLogType(String category) {
        String substVars;
        File file;
        Logger log = (Logger)LoggerFactory.getLogger(LogbackConfig.class);
        if (this.set.contains(category) && (file = new File(substVars = OptionHelper.substVars((String)("${logPath}" + FilenameUtils.getName((String)category)), (PropertyContainer)log.getLoggerContext()))).exists()) {
            return file;
        }
        return null;
    }

    public File getLog(String category, String name) {
        String substVars;
        File file;
        Logger log = (Logger)LoggerFactory.getLogger(LogbackConfig.class);
        if (this.set.contains(category) && (file = new File(substVars = OptionHelper.substVars((String)("${logPath}" + category + "/" + FilenameUtils.getName((String)name)), (PropertyContainer)log.getLoggerContext()))).exists()) {
            return file;
        }
        return null;
    }

    public List<Code> getAllCategory() {
        return this.codes;
    }
}

