/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.machine;

import com.google.common.collect.Maps;
import io.github.h800572003.exception.ApBusinessException;
import io.github.h800572003.machine.IStatus;
import io.github.h800572003.machine.IStatusActionHolder;
import io.github.h800572003.machine.StatusAction;
import io.github.h800572003.machine.StatusActionHolder;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class StatusMachine<T extends IStatus, R> {
    private Map<String, StatusActionHolder<T, R>> statusMap = Maps.newConcurrentMap();
    private StatusActionHolder.NotFoundKeyPolicy<T, R> notFoundKeyPolicy;

    public StatusMachine(StatusActionHolder.NotFoundKeyPolicy<T, R> notFoundKeyPolicy) {
        this.notFoundKeyPolicy = Objects.requireNonNull(notFoundKeyPolicy);
    }

    public StatusMachine() {
        this(new ExceptionPolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatusActionHolder<T, R> getStatusAction(IStatus status) {
        Class<StatusMachine> clazz = StatusMachine.class;
        synchronized (StatusMachine.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.statusMap.compute(status.toStatus(), (k, v) -> v == null ? new StatusActionHolder<T, R>(this.notFoundKeyPolicy) : v);
        }
    }

    public R run(StatusAction action, T src) {
        IStatusActionHolder<T, R> statusAction = this.getStatusAction((IStatus)src);
        Function<T, R> function = statusAction.getAction(action);
        return function.apply(src);
    }

    public static class ExceptionPolicy<T, R>
    implements StatusActionHolder.NotFoundKeyPolicy<T, R> {
        @Override
        public Function<T, R> none(StatusAction statusAction) {
            throw new ApBusinessException("action " + statusAction + " not register", new Object[0]);
        }
    }
}

