/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.properties;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.h800572003.properties.IProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public interface IPropertiesRepository {
    public List<IProperties> getProperties(String var1);

    public Optional<IProperties> getValue(String var1, String var2);

    public int update(String var1, IProperties var2);

    public int insert(String var1, IProperties var2);

    public int delete(String var1, String var2);

    public int delete(String var1);

    public static class PropertiesRepositoryInMen
    implements IPropertiesRepository {
        private final Map<String, List<IProperties>> map = new HashMap<String, List<IProperties>>();

        @Override
        public List<IProperties> getProperties(String category) {
            return this.map.getOrDefault(category, Lists.newArrayList());
        }

        @Override
        public Optional<IProperties> getValue(String category, String key) {
            List<IProperties> orDefault = this.map.getOrDefault(category, Lists.newArrayList());
            return orDefault.stream().filter(i -> i.getKey().equals(key)).findAny();
        }

        @Override
        public int update(String category, IProperties properties) {
            Optional<IProperties> value = this.getValue(category, properties.getKey());
            if (value.isPresent()) {
                HashSet newHashSet = Sets.newHashSet((Object[])new IProperties[]{properties});
                newHashSet.addAll(this.getProperties(category));
                this.map.put(category, newHashSet.stream().collect(Collectors.toList()));
                return 1;
            }
            return 0;
        }

        @Override
        public int insert(String category, IProperties properties) {
            Optional<IProperties> value = this.getValue(category, properties.getKey());
            if (value.isPresent()) {
                return 0;
            }
            List<IProperties> properties2 = this.getProperties(category);
            properties2.add(properties);
            this.map.put(category, properties2);
            return 1;
        }

        @Override
        public int delete(String category, String key) {
            List<IProperties> properties2 = this.getProperties(category);
            List collect = properties2.stream().filter(i -> !i.getKey().equals(key)).collect(Collectors.toList());
            this.map.put(category, collect);
            return properties2.size() != collect.size() ? 1 : 0;
        }

        @Override
        public int delete(String category) {
            List<IProperties> properties2 = this.getProperties(category);
            int size = properties2.size();
            properties2.clear();
            this.map.put(category, properties2);
            return size;
        }
    }
}

