/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.properties;

import com.google.common.cache.CacheLoader;
import com.google.common.collect.Sets;
import io.github.h800572003.properties.IProperties;
import io.github.h800572003.properties.IPropertiesRepository;
import io.github.h800572003.properties.MyProperties;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyCacheLoaderInCludeDefHolder
extends CacheLoader<String, List<IProperties>> {
    private static final Logger log = LoggerFactory.getLogger(MyCacheLoaderInCludeDefHolder.class);
    private final IPropertiesRepository propertiesRepository;
    private final List<IProperties> def;

    public MyCacheLoaderInCludeDefHolder(IPropertiesRepository propertiesRepository, List<IProperties> def) {
        this.propertiesRepository = propertiesRepository;
        this.def = def;
    }

    public List<IProperties> load(String key) throws Exception {
        try {
            List<IProperties> fromOutside = this.propertiesRepository.getProperties(key);
            Map<IProperties, IProperties> collect = this.def.stream().collect(Collectors.toMap(i -> i, i -> i));
            fromOutside.forEach(i -> {
                IProperties iProperties;
                boolean containsKey = collect.containsKey(i);
                if (containsKey && (iProperties = (IProperties)collect.get(i)) instanceof MyProperties && i instanceof MyProperties) {
                    MyProperties myProperties = (MyProperties)iProperties;
                    MyProperties iMy = (MyProperties)i;
                    iMy.setMeno(myProperties.getMemo());
                }
            });
            HashSet set = Sets.newHashSet(fromOutside);
            set.addAll(this.def);
            return set.stream().sorted(Comparator.comparing(IProperties::getKey)).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("key {},get data error", (Object)key, (Object)e);
            return this.def;
        }
    }
}

