/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.properties;

import com.google.common.cache.CacheLoader;
import com.google.common.collect.Sets;
import io.github.h800572003.properties.IProperties;
import io.github.h800572003.properties.IPropertiesRepository;
import io.github.h800572003.properties.MyProperties;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyCacheLoaderInRangDefHolder
extends CacheLoader<String, List<IProperties>> {
    private static final Logger log = LoggerFactory.getLogger(MyCacheLoaderInRangDefHolder.class);
    private final IPropertiesRepository propertiesRepository;
    private final List<IProperties> def;

    public MyCacheLoaderInRangDefHolder(IPropertiesRepository propertiesRepository, List<IProperties> def) {
        this.propertiesRepository = propertiesRepository;
        this.def = def;
    }

    public List<IProperties> load(String key) throws Exception {
        try {
            List<IProperties> fromOutside = this.propertiesRepository.getProperties(key);
            Map<String, IProperties> fromOutMap = fromOutside.stream().collect(Collectors.toMap(IProperties::getKey, i -> i));
            List collect = this.def.stream().map(i -> this.createNew((IProperties)i, fromOutMap)).collect(Collectors.toList());
            HashSet set = Sets.newHashSet(collect);
            return set.stream().sorted(Comparator.comparing(IProperties::getKey)).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("key {},get data error", (Object)key, (Object)e);
            return this.def;
        }
    }

    private IProperties createNew(IProperties properties, Map<String, IProperties> fromOutMap) {
        MyProperties myProperties = new MyProperties();
        myProperties.setKey(properties.getKey());
        myProperties.setValue1(properties.getValue1());
        myProperties.setValue2(properties.getValue2());
        myProperties.setValue3(properties.getValue3());
        if (properties instanceof MyProperties) {
            MyProperties pro = (MyProperties)properties;
            myProperties.setMeno(pro.getMemo());
        }
        if (fromOutMap.containsKey(properties.getKey())) {
            IProperties iProperties = fromOutMap.get(properties.getKey());
            myProperties.setValue1(iProperties.getValue1());
            myProperties.setValue2(iProperties.getValue2());
            myProperties.setValue3(iProperties.getValue3());
        }
        return myProperties;
    }
}

