/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.properties;

import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import io.github.h800572003.properties.IPropertieServiceHolder;
import io.github.h800572003.properties.IProperties;
import io.github.h800572003.properties.IPropertiesRepository;
import io.github.h800572003.properties.MyCacheLoaderInCludeDefHolder;
import io.github.h800572003.properties.MyCacheLoaderInRangDefHolder;
import io.github.h800572003.properties.PropertiesInCacheHolder;
import io.github.h800572003.properties.PropertiesInNoCacheHolder;
import java.util.List;
import java.util.Objects;

public class PropertiesHolderBuilder {
    private boolean inRange = true;
    private boolean isCache = true;
    private List<IProperties> def = Lists.newArrayList();

    public PropertiesHolderBuilder(boolean inRange, boolean isCache) {
        this.inRange = inRange;
        this.isCache = isCache;
    }

    public PropertiesHolderBuilder setProperties(List<IProperties> def) {
        Objects.requireNonNull(def);
        this.def = def;
        return this;
    }

    public IPropertieServiceHolder build(String category, IPropertiesRepository propertiesRepository) {
        Objects.requireNonNull(category);
        Objects.requireNonNull(propertiesRepository);
        Objects.requireNonNull(this.def);
        CacheLoader loader = new MyCacheLoaderInRangDefHolder(propertiesRepository, this.def);
        if (!this.inRange) {
            loader = new MyCacheLoaderInCludeDefHolder(propertiesRepository, this.def);
        }
        IPropertieServiceHolder holder = new PropertiesInCacheHolder(category, propertiesRepository, (CacheLoader<String, List<IProperties>>)loader);
        if (!this.isCache) {
            holder = new PropertiesInNoCacheHolder(category, propertiesRepository, (CacheLoader<String, List<IProperties>>)loader);
        }
        return holder;
    }
}

