/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.properties;

import com.google.common.cache.CacheLoader;
import io.github.h800572003.exception.ApBusinessException;
import io.github.h800572003.properties.IPropertieServiceHolder;
import io.github.h800572003.properties.IProperties;
import io.github.h800572003.properties.IPropertiesRepository;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesInCacheHolder
implements IPropertieServiceHolder {
    private static final Logger log = LoggerFactory.getLogger(PropertiesInCacheHolder.class);
    private final IPropertiesRepository propertiesRepository;
    private final String category;
    private final CacheLoader<String, List<IProperties>> cacheLoader;
    private List<IProperties> cacheList;

    public PropertiesInCacheHolder(String category, IPropertiesRepository propertiesRepository, CacheLoader<String, List<IProperties>> cacheLoader) {
        this.propertiesRepository = propertiesRepository;
        this.category = category;
        this.cacheLoader = cacheLoader;
    }

    private PropertiesInCacheHolder initial() {
        if (this.cacheList == null) {
            this.loadData();
        }
        return this;
    }

    private synchronized PropertiesInCacheHolder loadData() {
        try {
            if (this.cacheList != null) {
                return this;
            }
            this.cacheList = (List)this.cacheLoader.load((Object)this.category);
        }
        catch (Exception e) {
            throw new ApBusinessException("CATEGORY:{0} \u53c3\u6578\u932f\u8aa4", this.category);
        }
        return this;
    }

    @Override
    public synchronized List<IProperties> getProperties() {
        return this.initial().getCacheList();
    }

    public List<IProperties> getCacheList() {
        return this.cacheList;
    }

    @Override
    public Optional<IProperties> getPropertie(String key) {
        return this.getProperties().stream().filter(i -> StringUtils.equals((CharSequence)i.getKey(), (CharSequence)key)).findAny();
    }

    @Override
    public void saveOrUpdate(IProperties properties) {
        if (StringUtils.isBlank((CharSequence)properties.getKey())) {
            throw new ApBusinessException("{0} KEY\u4e0d\u5f97\u70ba\u7a7a\u503c", properties.getKey());
        }
        Optional<IProperties> value = this.propertiesRepository.getValue(this.category, properties.getKey());
        if (value.isPresent()) {
            int update = this.propertiesRepository.update(this.category, properties);
            log.info("update size:{}", (Object)update);
        } else {
            int insert = this.propertiesRepository.insert(this.category, properties);
            log.info("insert size:{}", (Object)insert);
        }
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        PropertiesInCacheHolder propertiesInCacheHolder = this;
        synchronized (propertiesInCacheHolder) {
            this.cacheList = null;
        }
    }

    @Override
    public void delete(String code) {
        int delete = this.propertiesRepository.delete(this.category, code);
        log.info("delete code:{}", (Object)delete);
        this.clear();
    }

    @Override
    public void delete() {
        int delete = this.propertiesRepository.delete(this.category);
        log.info("delete code:{}", (Object)delete);
        this.clear();
    }
}

