/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.properties;

import com.google.common.cache.CacheLoader;
import io.github.h800572003.exception.ApBusinessException;
import io.github.h800572003.properties.IPropertieServiceHolder;
import io.github.h800572003.properties.IProperties;
import io.github.h800572003.properties.IPropertiesRepository;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesInNoCacheHolder
implements IPropertieServiceHolder {
    private static final Logger log = LoggerFactory.getLogger(PropertiesInNoCacheHolder.class);
    private final IPropertiesRepository propertiesRepository;
    private final String category;
    private final CacheLoader<String, List<IProperties>> cacheLoader;

    public PropertiesInNoCacheHolder(String category, IPropertiesRepository propertiesRepository, CacheLoader<String, List<IProperties>> cacheLoader) {
        this.propertiesRepository = propertiesRepository;
        this.category = category;
        this.cacheLoader = cacheLoader;
    }

    @Override
    public List<IProperties> getProperties() {
        return this.loader();
    }

    private List<IProperties> loadByOutside() {
        try {
            return (List)this.cacheLoader.load((Object)this.category);
        }
        catch (Exception e) {
            throw new ApBusinessException("CATEGORY:{0} \u53c3\u6578\u932f\u8aa4", this.category);
        }
    }

    private synchronized List<IProperties> loader() {
        return this.loadByOutside();
    }

    @Override
    public Optional<IProperties> getPropertie(String key) {
        return this.getProperties().stream().filter(i -> StringUtils.equals((CharSequence)i.getKey(), (CharSequence)key)).findAny();
    }

    @Override
    public void saveOrUpdate(IProperties properties) {
        if (StringUtils.isBlank((CharSequence)properties.getKey())) {
            throw new ApBusinessException("{0} KEY\u4e0d\u5f97\u70ba\u7a7a\u503c", properties.getKey());
        }
        Optional<IProperties> value = this.propertiesRepository.getValue(this.category, properties.getKey());
        if (value.isPresent()) {
            int update = this.propertiesRepository.update(this.category, properties);
            log.info("update size:{}", (Object)update);
        } else {
            int insert = this.propertiesRepository.insert(this.category, properties);
            log.info("insert size:{}", (Object)insert);
        }
        this.clear();
    }

    @Override
    public void clear() {
    }

    @Override
    public void delete(String code) {
        int delete = this.propertiesRepository.delete(this.category, code);
        log.info("delete code:{}", (Object)delete);
        this.clear();
    }

    @Override
    public void delete() {
        int delete = this.propertiesRepository.delete(this.category);
        log.info("delete code:{}", (Object)delete);
        this.clear();
    }
}

