/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.properties;

import io.github.h800572003.exception.ApBusinessException;
import io.github.h800572003.properties.Code;
import io.github.h800572003.properties.IPropertieServiceHolder;
import io.github.h800572003.properties.IProperties;
import io.github.h800572003.properties.IPropertiesRepository;
import io.github.h800572003.properties.IPropertiesService;
import io.github.h800572003.properties.MyProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesService
implements IPropertiesService {
    private static final Logger log = LoggerFactory.getLogger(PropertiesService.class);
    private final Map<String, IPropertieServiceHolder> map = new ConcurrentHashMap<String, IPropertieServiceHolder>();
    private final List<Code> codes = new ArrayList<Code>();
    private List<IPropertiesService.PropertiesUpdateListener> propertiesUpdates = new ArrayList<IPropertiesService.PropertiesUpdateListener>();

    @Override
    public void addListener(IPropertiesService.PropertiesUpdateListener propertiesUpdateListener) {
        this.propertiesUpdates.add(propertiesUpdateListener);
    }

    public void removeCode(String code) {
        this.map.remove(code);
        Code myCode = new Code();
        myCode.setKey(code);
        myCode.setValue("");
        this.codes.remove(myCode);
    }

    @Override
    public void addCode(String code, String name, IPropertieServiceHolder holder) {
        if (this.map.containsKey(code)) {
            throw new ApBusinessException("\u91cd\u8907\u4ee3\u78bc{0}", code);
        }
        this.map.put(code, holder);
        Code myCode = new Code();
        myCode.setKey(code);
        myCode.setValue(name);
        this.codes.add(myCode);
    }

    protected PropertiesService(IPropertiesRepository propertiesRepository) {
    }

    private List<IProperties> getCodeByDefault(String code, List<IProperties> def) {
        if (this.map.containsKey(code)) {
            return this.map.get(code).getProperties();
        }
        log.info("code:{} use def value", (Object)code);
        return def;
    }

    @Override
    public List<IProperties> getPropertie(String code) {
        Objects.requireNonNull(code);
        return this.getCodeByDefault(code, Arrays.asList(new IProperties[0]));
    }

    @Override
    public IProperties getValue(String code, String key) {
        Objects.requireNonNull(code);
        Objects.requireNonNull(key);
        if (this.map.containsKey(code)) {
            Optional<IProperties> propertie = this.map.get(code).getPropertie(key);
            return propertie.orElseGet(() -> new MyProperties());
        }
        log.info("code:{} use def value", (Object)code);
        return new MyProperties();
    }

    @Override
    public void saveOrUpdate(String category, IProperties properties) {
        this.propertiesUpdates.forEach(i -> i.update(category, properties));
        if (this.map.containsKey(category)) {
            this.map.get(category).saveOrUpdate(properties);
        }
    }

    @Override
    public void clear(String category) {
        if (this.map.containsKey(category)) {
            this.map.get(category).clear();
        }
    }

    @Override
    public void delete(String category, String code) {
        if (this.map.containsKey(category)) {
            this.map.get(category).delete(code);
        }
    }

    @Override
    public List<Code> getCategory() {
        return this.codes;
    }

    @Override
    public void delete(String category) {
        if (this.map.containsKey(category)) {
            this.map.get(category).delete();
        }
    }

    @Override
    public void clear() {
        this.codes.forEach(i -> this.clear(i.getKey()));
    }

    @Override
    public void update() {
        this.clear();
        this.codes.forEach(this::loadProperties);
    }

    private void loadProperties(Code code) {
        log.info("loadProperties:" + code.getKey());
        this.getPropertie(code.getKey());
    }
}

