/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.scheduling;

import io.github.h800572003.date.DateUtlis;
import io.github.h800572003.exception.CancelExecpetion;
import io.github.h800572003.scheduling.IScheduingKey;
import io.github.h800572003.scheduling.IScheduingMonitor;
import io.github.h800572003.scheduling.IScheduingTask;
import io.github.h800572003.scheduling.IScheduingTaskContext;
import io.github.h800572003.scheduling.ISchedulingContext;
import io.github.h800572003.scheduling.ISchedulingItemContext;
import io.github.h800572003.scheduling.SchedulingStatusCodes;
import io.github.h800572003.scheduling.TaskHolder;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;

public abstract class AbstractSchedulingCronContextHolder
implements ISchedulingItemContext,
IScheduingTaskContext,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(AbstractSchedulingCronContextHolder.class);
    protected IScheduingKey scheduingKey;
    protected TaskScheduler taskScheduler;
    protected IScheduingTask scheduingTask;
    protected String message = "";
    protected ScheduledFuture<?> scheduledFuture = null;
    protected String startTime = "";
    protected String endTime = "";
    protected SchedulingStatusCodes status = SchedulingStatusCodes.IDLE;
    protected IScheduingMonitor monitors;
    protected ISchedulingContext mainContext;
    protected boolean isUp = true;
    protected static byte[] UP_LOCK = new byte[0];
    private int progress = -1;

    public AbstractSchedulingCronContextHolder(IScheduingKey scheduingKey, TaskScheduler taskScheduler, IScheduingTask scheduingTask, IScheduingMonitor monitors, ISchedulingContext mainContext) {
        this.scheduingKey = scheduingKey;
        this.taskScheduler = taskScheduler;
        this.scheduingTask = scheduingTask;
        this.monitors = monitors;
        this.mainContext = mainContext;
    }

    @Override
    public void runOnce() {
        log.info("call runOnce code:{} ", (Object)this.scheduingKey.getCode());
        new Thread(new Runnable(){

            @Override
            public void run() {
                AbstractSchedulingCronContextHolder.this.run();
            }
        }).start();
    }

    @Override
    public final void start() {
        this.myStart();
    }

    protected abstract void myStart();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cancel() {
        AbstractSchedulingCronContextHolder abstractSchedulingCronContextHolder = this;
        synchronized (abstractSchedulingCronContextHolder) {
            this.mainContext.ifExecuter(() -> {
                this.setUp(false);
                log.info("call {}\u670d\u52d9\u4e2d\u65b7", (Object)this.scheduingKey.getCode());
                if (this.scheduledFuture != null && !this.scheduledFuture.isCancelled()) {
                    log.info("call cancel code:{} ", (Object)this.scheduingKey.getCode());
                    boolean cancel = this.scheduledFuture.cancel(true);
                    if (cancel && !this.status.equals((Object)SchedulingStatusCodes.RUNNNIG)) {
                        this.termiat();
                    }
                } else {
                    log.info("{}\u670d\u52d9\u5df2\u95dc\u9589", (Object)this.scheduingKey.getCode());
                }
            });
        }
    }

    private void termiat() {
        try {
            log.info("\u670d\u52d9{},\u4e2d\u6b62\u958b\u59cb", (Object)this.scheduingKey.getCode());
            log.info("termiat code:{} ", (Object)this.scheduingKey.getCode());
            this.status = SchedulingStatusCodes.DEAD;
            this.scheduledFuture = null;
            this.monitors.updateCancel(this);
            log.info("\u670d\u52d9{},\u4e2d\u6b62\u6210\u529f", (Object)this.scheduingKey.getCode());
        }
        finally {
            log.info("\u670d\u52d9{},\u4e2d\u6b62\u7d50\u675f", (Object)this.scheduingKey.getCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void refresh() {
        AbstractSchedulingCronContextHolder abstractSchedulingCronContextHolder = this;
        synchronized (abstractSchedulingCronContextHolder) {
            this.myRefresh();
        }
    }

    protected abstract void myRefresh();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Class<? extends IScheduingTask> clazz = this.scheduingKey.getPClass();
        synchronized (clazz) {
            try {
                TaskHolder.set(this);
                this.setUp(true);
                this.setProgress(-1);
                this.message = "";
                log.info("code:{} start", (Object)this.scheduingKey.getCode());
                this.startTime = DateUtlis.getText();
                this.endTime = "";
                this.status = SchedulingStatusCodes.RUNNNIG;
                this.monitors.updateStart(this);
                this.scheduingTask.execute(this);
            }
            catch (Exception e) {
                this.monitors.updateError(this, e);
                this.message = ExceptionUtils.getStackTrace((Throwable)e);
                log.error("code:{} error", (Object)this.scheduingKey.getCode(), (Object)e);
            }
            finally {
                if (this.scheduledFuture != null) {
                    if (this.scheduledFuture.isCancelled()) {
                        this.status = SchedulingStatusCodes.DEAD;
                        this.termiat();
                    } else {
                        this.status = SchedulingStatusCodes.RUNNABLE;
                    }
                } else {
                    this.status = SchedulingStatusCodes.IDLE;
                }
                this.endTime = DateUtlis.getText();
                log.info("code:{} end", (Object)this.scheduingKey.getCode());
                this.monitors.updateEnd(this);
                TaskHolder.clear();
            }
        }
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public String getEndTime() {
        return this.endTime;
    }

    @Override
    public String getStatus() {
        return this.status.name();
    }

    @Override
    public String getCode() {
        return this.scheduingKey.getCode();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public abstract String getCron();

    @Override
    public String getName() {
        return this.scheduingKey.getName();
    }

    @Override
    public boolean isActived() {
        return this.scheduingKey.isActived();
    }

    @Override
    public String getNextSec() {
        if (this.scheduledFuture == null) {
            return "";
        }
        return this.scheduledFuture.getDelay(TimeUnit.SECONDS) + "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        AbstractSchedulingCronContextHolder abstractSchedulingCronContextHolder = this;
        synchronized (abstractSchedulingCronContextHolder) {
            this.setUp(false);
            log.info("destroy code:{}", (Object)this.scheduingKey.getCode());
            this.mainContext.ifExecuter(() -> this.monitors.destroy(this));
            log.info("\u670d\u52d9\u5df2\u56de\u6536\u6210\u529f{}", (Object)this.scheduingKey.getCode());
        }
    }

    @Override
    public void updateMessage(String message) {
        this.message = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkUp() throws CancelExecpetion {
        byte[] byArray = UP_LOCK;
        synchronized (UP_LOCK) {
            if (!this.isUp) {
                this.isUp = true;
                throw new CancelExecpetion("\u7a0b\u5f0f\u4e2d\u65b7", new Object[0]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp(boolean isUp) {
        byte[] byArray = UP_LOCK;
        synchronized (UP_LOCK) {
            this.isUp = isUp;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getUp() {
        byte[] byArray = UP_LOCK;
        synchronized (UP_LOCK) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.isUp;
        }
    }

    @Override
    public void setProgress(int progress) {
        this.progress = progress > 100 ? 100 : progress;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }
}

