/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.scheduling;

import io.github.h800572003.exception.ApBusinessException;
import io.github.h800572003.scheduling.AbstractSchedulingCronContextHolder;
import io.github.h800572003.scheduling.IScheduingCron;
import io.github.h800572003.scheduling.IScheduingMonitor;
import io.github.h800572003.scheduling.IScheduingTask;
import io.github.h800572003.scheduling.ISchedulingContext;
import io.github.h800572003.scheduling.ISchedulingItemContext;
import io.github.h800572003.scheduling.ISchedulingRepository;
import io.github.h800572003.scheduling.SchedulingStatusCodes;
import io.github.h800572003.scheduling.SpringSchedulingManager;
import java.util.Calendar;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

public class SchedulingCronContextHolderDTO
extends AbstractSchedulingCronContextHolder
implements ISchedulingItemContext,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(SchedulingCronContextHolderDTO.class);
    IScheduingCron scheduingCron;
    ISchedulingRepository schedulingRepository;
    ISchedulingContext schedulingContext;

    public SchedulingCronContextHolderDTO(IScheduingCron scheduingCron, TaskScheduler taskScheduler, IScheduingTask task, IScheduingMonitor scheduingTaskLog, ISchedulingRepository schedulingRepository, ISchedulingContext schedulingContext) {
        super(scheduingCron, taskScheduler, task, scheduingTaskLog, schedulingContext);
        this.scheduingCron = Objects.requireNonNull(scheduingCron);
        this.taskScheduler = Objects.requireNonNull(taskScheduler);
        this.schedulingRepository = schedulingRepository;
        this.schedulingContext = schedulingContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void myStart() {
        log.debug("\u547c\u53eb\u555f\u52d5\u670d\u52d9:{}\u958b\u59cb", (Object)this.scheduingKey.getCode());
        SchedulingCronContextHolderDTO schedulingCronContextHolderDTO = this;
        synchronized (schedulingCronContextHolderDTO) {
            try {
                this.mainContext.ifExecuter(() -> {
                    if (this.scheduingCron.isActived()) {
                        if (this.scheduledFuture == null) {
                            try {
                                if (StringUtils.isNumeric((CharSequence)this.scheduingCron.getCon())) {
                                    Calendar instance = Calendar.getInstance();
                                    SpringSchedulingManager.ISpringSchedulingProperites properites = this.schedulingContext.getProperites();
                                    instance.add(13, properites.getDelayStart());
                                    this.scheduledFuture = this.taskScheduler.scheduleWithFixedDelay((Runnable)this, instance.getTime(), Long.parseLong(this.scheduingCron.getCon()));
                                } else {
                                    CronTrigger t = new CronTrigger(this.scheduingCron.getCon());
                                    this.scheduledFuture = this.taskScheduler.schedule((Runnable)this, (Trigger)t);
                                }
                                this.status = SchedulingStatusCodes.RUNNABLE;
                            }
                            catch (TaskRejectedException e) {
                                throw new ApBusinessException("\u5df2\u95dc\u6a5f\u4e0d\u63d0\u4f9b\u4f5c\u696d\u65b0\u589e{0}", this.scheduingKey.getCode());
                            }
                        } else {
                            throw new ApBusinessException("{0}\u5df2\u555f\u52d5\uff0c\u8acb\u5148\u95dc\u9589", this.scheduingKey.getCode());
                        }
                    }
                });
            }
            finally {
                log.debug("\u547c\u53eb\u555f\u52d5\u670d\u52d9:{}\u7d50\u675f", (Object)this.scheduingKey.getCode());
            }
        }
    }

    @Override
    public String getCron() {
        return this.scheduingCron.getCon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void myRefresh() {
        SchedulingCronContextHolderDTO schedulingCronContextHolderDTO = this;
        synchronized (schedulingCronContextHolderDTO) {
            if (this.scheduledFuture != null) {
                throw new ApBusinessException("{0}\u5df2\u555f\u52d5\uff0c\u8acb\u5148\u95dc\u9589", this.scheduingKey.getCode());
            }
            this.scheduingCron = this.schedulingRepository.getCcheduingCronsTask(this.scheduingCron.getCode());
            log.info("\u670d\u52d9\u66f4\u65b0\u6210\u529f{}", (Object)this.scheduingKey.getCode());
        }
    }

    @Override
    public boolean isActived() {
        return this.scheduingCron.isActived();
    }

    @Override
    public String getName() {
        return this.scheduingCron.getName();
    }
}

