/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.scheduling;

import io.github.h800572003.exception.ApBusinessException;
import io.github.h800572003.scheduling.IScheduingCron;
import io.github.h800572003.scheduling.IScheduingDelay;
import io.github.h800572003.scheduling.IScheduingMonitor;
import io.github.h800572003.scheduling.IScheduingTask;
import io.github.h800572003.scheduling.ISchedulingContext;
import io.github.h800572003.scheduling.ISchedulingItemContext;
import io.github.h800572003.scheduling.ISchedulingManager;
import io.github.h800572003.scheduling.ISchedulingRepository;
import io.github.h800572003.scheduling.SchedulingCronContextHolderDTO;
import io.github.h800572003.scheduling.SchedulingDelayContextHolderDTO;
import io.github.h800572003.scheduling.SchedulingStatusCodes;
import io.github.h800572003.utils.HostNameUtls;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

public class SpringSchedulingManager
implements ISchedulingManager {
    private static final Logger log = LoggerFactory.getLogger(SpringSchedulingManager.class);
    final Map<String, ISchedulingItemContext> map = new ConcurrentHashMap<String, ISchedulingItemContext>();
    final List<ISchedulingItemContext> list = Collections.synchronizedList(new ArrayList());
    private final ISchedulingRepository repository;
    private final ApplicationContext applicationContext;
    private final IScheduingMonitor myScheduingMonitors;
    private ScheduledTaskRegistrar taskRegistrar;
    private int extractThreadSize = 2;
    private SpringSchedulingHook springSchedulingHook = new SpringSchedulingHook.BalankSpringSchedulingHook();
    private final ISpringSchedulingProperites springSchedulingProperites;
    private ThreadPoolTaskScheduler scheduler;
    private boolean lock = false;
    private Byte[] lockKey = new Byte[0];
    private CustomizableThreadFactory customizableThreadFactory = new CustomizableThreadFactory("my-task-scheduler"){
        private static final long serialVersionUID = 1L;

        public Thread newThread(Runnable runnable) {
            Thread thread = super.newThread(runnable);
            SpringSchedulingManager.this.threads.add(thread);
            return thread;
        }
    };
    private List<Thread> threads = new ArrayList<Thread>();

    public void add(IScheduingCron code) {
        if (this.map.containsKey(code.getCode())) {
            throw new ApBusinessException("\u4efb\u52d9\u4ee3\u78bc\u91cd\u8907{0}", code.getCode());
        }
        log.info("add task:{} name:{} cron:({})", new Object[]{code.getCode(), code.getName(), code.getCon()});
        this.add(code, (ISchedulingItemContext)new SchedulingCronContextHolderDTO(code, (TaskScheduler)this.scheduler, (IScheduingTask)this.applicationContext.getBean(code.getPClass()), this.myScheduingMonitors, this.repository, this.getContext()));
    }

    protected void add(IScheduingCron code, ISchedulingItemContext schedulingItemContext) {
        this.map.put(code.getCode(), schedulingItemContext);
    }

    public void add(IScheduingDelay code) {
        if (this.map.containsKey(code.getCode())) {
            throw new ApBusinessException("\u4efb\u52d9\u4ee3\u78bc\u91cd\u8907{0}", code.getCode());
        }
        log.info("add task:{} name:{} cron:({})", new Object[]{code.getCode(), code.getName(), code.getCron()});
        this.add(code, (ISchedulingItemContext)new SchedulingDelayContextHolderDTO(code, (TaskScheduler)this.scheduler, (IScheduingTask)this.applicationContext.getBean(code.getPClass()), this.myScheduingMonitors, this.repository, this.getContext()));
    }

    protected void add(IScheduingDelay code, ISchedulingItemContext schedulingItemContext) {
        this.map.put(code.getCode(), schedulingItemContext);
    }

    @Override
    public void propertiesChange() {
        this.init();
    }

    private ThreadPoolTaskScheduler initScheduler(int size) {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler(){
            private static final long serialVersionUID = -1L;

            public void destroy() {
                this.getScheduledThreadPoolExecutor().setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
                super.destroy();
            }
        };
        scheduler.setWaitForTasksToCompleteOnShutdown(true);
        scheduler.setAwaitTerminationSeconds(30);
        scheduler.setPoolSize(size);
        scheduler.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        scheduler.setThreadFactory((ThreadFactory)this.customizableThreadFactory);
        scheduler.initialize();
        return scheduler;
    }

    @Override
    public final void refresh(String code) {
        this.busy();
        this.init(code).refresh();
    }

    @Override
    public final void start(String code) {
        this.busy();
        this.init(code).start();
    }

    @Override
    public final void runOnce(String code) {
        this.busy();
        this.init(code).runOnce();
    }

    @Override
    public final void cancel(String code) {
        this.busy();
        this.init(code).cancel();
    }

    @Override
    public final void cancelAll() {
        this.busy();
        this.map.values().forEach(item -> item.cancel());
    }

    @Override
    public final void startAll() {
        this.busy();
        this.map.values().forEach(item -> item.start());
    }

    public List<ISchedulingItemContext> getTasks() {
        return this.list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void down() {
        this.busy();
        SpringSchedulingManager springSchedulingManager = this;
        synchronized (springSchedulingManager) {
            log.info("down start..");
            try {
                this.lock = true;
                if (this.taskRegistrar == null) {
                    log.info("\u670d\u52d9\u5df2\u95dc\u9589");
                    throw new ApBusinessException("\u670d\u52d9\u5df2\u95dc\u9589", new Object[0]);
                }
                this.map.values().forEach(item -> item.cancel());
                this.map.values().forEach(item -> {
                    try {
                        item.destroy();
                    }
                    catch (ApBusinessException e) {
                        log.error("\u5f37\u5236\u95dc\u9589\u5ffd\u7565\u8b66\u544a error:", (Throwable)e);
                    }
                });
                this.scheduler.setAwaitTerminationSeconds(this.springSchedulingProperites.getCloseTimeout());
                this.scheduler.destroy();
                this.scheduler = null;
                this.taskRegistrar.destroy();
                this.taskRegistrar = null;
                this.springSchedulingHook.downHook();
            }
            finally {
                this.lock = false;
                log.info("down end..");
            }
        }
    }

    private void init() {
        ThreadPoolTaskScheduler scheduler;
        this.map.clear();
        this.list.clear();
        List<IScheduingDelay> scheduingDelays = this.repository.getDelayTask();
        List<IScheduingCron> scheduingCrons = this.repository.getCcheduingCronsTask();
        this.taskRegistrar = null;
        this.taskRegistrar = new ScheduledTaskRegistrar();
        int size = scheduingDelays.size() + scheduingCrons.size() + this.extractThreadSize;
        log.info(" Scheduling execute thread size:{}", (Object)size);
        this.scheduler = scheduler = this.initScheduler(size + 2);
        this.taskRegistrar.setTaskScheduler((TaskScheduler)scheduler);
        scheduingDelays.forEach(this::add);
        scheduingCrons.forEach(this::add);
        this.list.addAll(this.map.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void up() {
        this.busy();
        SpringSchedulingManager springSchedulingManager = this;
        synchronized (springSchedulingManager) {
            log.info("up start..");
            try {
                if (this.taskRegistrar != null) {
                    log.info("\u670d\u52d9\u5df2\u555f\u52d5");
                    throw new ApBusinessException("\u670d\u52d9\u5df2\u555f\u52d5", new Object[0]);
                }
                long count = this.threads.stream().filter(Thread::isAlive).count();
                if (count > 0L) {
                    throw new ApBusinessException("\u4efb\u52d9\u5c1a\u672a\u5b8c\u5168\u505c\u6b62\uff0c\u8acb\u7a0d\u5f8c", new Object[0]);
                }
                this.taskRegistrar = new ScheduledTaskRegistrar();
                this.init();
                this.springSchedulingHook.upHook();
            }
            finally {
                log.info("up end..");
            }
        }
        this.startAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void busy() {
        Byte[] byteArray = this.lockKey;
        synchronized (this.lockKey) {
            if (this.lock) {
                throw new ApBusinessException("\u670d\u52d9\u5fd9\u788c\u4e2d\u8acb\u7a0d\u5f8c\u64cd\u4f5c", new Object[0]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private ISchedulingItemContext init(String code) {
        ISchedulingItemContext orDefault = this.map.getOrDefault(code, null);
        if (orDefault == null) {
            throw new ApBusinessException("\u4efb\u52d9\u4e0d\u5b58\u5728{0}", code);
        }
        return orDefault;
    }

    public void setSpringSchedulingHook(SpringSchedulingHook springSchedulingHook) {
        this.springSchedulingHook = springSchedulingHook;
    }

    @Override
    public ISchedulingContext getContext() {
        return new SchedulingContext();
    }

    protected SpringSchedulingManager(ISchedulingRepository repository, ApplicationContext applicationContext, IScheduingMonitor myScheduingMonitors, ISpringSchedulingProperites springSchedulingProperites) {
        this.repository = repository;
        this.applicationContext = applicationContext;
        this.myScheduingMonitors = myScheduingMonitors;
        this.springSchedulingProperites = springSchedulingProperites;
    }

    public static interface SpringSchedulingHook {
        public void downHook();

        public void upHook();

        public static class BalankSpringSchedulingHook
        implements SpringSchedulingHook {
            @Override
            public void downHook() {
            }

            @Override
            public void upHook() {
            }
        }
    }

    public static interface ISpringSchedulingProperites {
        public boolean isExecute();

        default public int getCloseTimeout() {
            return 1800;
        }

        default public int getDelayStart() {
            return 10;
        }
    }

    class SchedulingContext
    implements ISchedulingContext {
        SchedulingContext() {
        }

        @Override
        public boolean isExecuter() {
            return SpringSchedulingManager.this.springSchedulingProperites.isExecute();
        }

        @Override
        public String getHostName() {
            return HostNameUtls.getHostName().toUpperCase();
        }

        @Override
        public List<ISchedulingItemContext> getAll() {
            List<ISchedulingItemContext> tasks = SpringSchedulingManager.this.getTasks();
            tasks.sort((s1, s2) -> s1.getCode().compareTo(s2.getCode()));
            return tasks;
        }

        @Override
        public boolean isStart() {
            return SpringSchedulingManager.this.taskRegistrar != null;
        }

        @Override
        public int getRunningCount() {
            return SpringSchedulingManager.this.getTasks().stream().mapToInt(i -> {
                boolean equals = i.getStatus().equals(SchedulingStatusCodes.RUNNNIG.name());
                return equals ? 1 : 0;
            }).reduce(0, Integer::sum);
        }

        @Override
        public ISpringSchedulingProperites getProperites() {
            return SpringSchedulingManager.this.springSchedulingProperites;
        }
    }
}

