/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.textcut;

import io.github.h800572003.exception.ApBusinessException;
import io.github.h800572003.textcut.TextByteCutHolder;
import io.github.h800572003.textcut.TextCutRoleConfig;
import io.github.h800572003.textcut.TextCutType;
import io.github.h800572003.textcut.TextStringCutHolder;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TextCutHelper {
    public static <T> T to(TextCutRoleConfig<T> config, String text) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(text);
        TextCutType textCutType = config.textCutType;
        if (textCutType.equals((Object)TextCutType.BYTE)) {
            return new TextByteCutHolder<T>(config, text).get();
        }
        if (textCutType.equals((Object)TextCutType.CHAR)) {
            return new TextStringCutHolder<T>(config, text).get();
        }
        throw new ApBusinessException("\u7121\u6b64\u5b9a\u7fa9\u898f\u5247" + (Object)((Object)textCutType), new Object[0]);
    }

    public static <T> List<T> to(TextCutRoleConfig<T> config, List<String> lines) {
        return lines.stream().map(i -> TextCutHelper.to(config, i)).collect(Collectors.toList());
    }
}

