/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.type;

import com.google.common.collect.Maps;
import io.github.h800572003.exception.ApBusinessException;
import io.github.h800572003.type.ITypeContext;
import io.github.h800572003.type.TypeKey;
import java.util.Map;
import java.util.function.Function;

public class TypeService<I extends ITypeContext> {
    private Map<TypeKey, Function<I, ?>> map = Maps.newConcurrentMap();
    private NotFoundKeyPolicy<I> notFondPolicy = new ExceptionPolicy();

    public TypeService() {
        this(new ExceptionPolicy());
    }

    public TypeService(NotFoundKeyPolicy<I> notFondPolicy) {
        this.notFondPolicy = notFondPolicy;
    }

    public static <I extends ITypeContext, O> TypeService<I> createService(NotFoundKeyPolicy<I> notFondPolicy) {
        return new TypeService<I>(notFondPolicy);
    }

    public static <I extends ITypeContext> TypeService<I> createService() {
        return new TypeService<I>();
    }

    public void register(String status, Function<I, ?> function) {
        TypeKey typeKey = TypeKey.create(status);
        if (this.map.containsKey(typeKey)) {
            throw new ApBusinessException("\u5df2\u91cd\u8907\u8a3b\u518a{0}", status);
        }
        this.map.put(typeKey, function);
    }

    public Object dispatch(I input) {
        Function<I, ?> orDefault = this.map.getOrDefault(TypeKey.create(input), null);
        if (orDefault == null) {
            orDefault = this.notFondPolicy.none(input);
        }
        return orDefault.apply(input);
    }

    public static class MissPolicy<I>
    implements NotFoundKeyPolicy<I> {
        @Override
        public Function<I, ?> none(Object typeServiceKey) {
            return new Function<I, Object>(){

                @Override
                public Object apply(I t) {
                    return null;
                }
            };
        }
    }

    public static class ExceptionPolicy<I>
    implements NotFoundKeyPolicy<I> {
        @Override
        public Function<I, ?> none(Object typeServiceKey) {
            throw new ApBusinessException("\u672a\u5b9a\u7fa9\u8a72\u72c0\u614b:", new Object[0]);
        }
    }

    public static interface NotFoundKeyPolicy<I> {
        public Function<I, ?> none(Object var1);
    }
}

