/*
 * Decompiled with CFR 0.152.
 */
package io.github.jocelynmutso.zoe.quarkus.ide.handlers;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.StaticHandler;

public class UiStaticHandler
implements Handler<RoutingContext> {
    private String uiFinalDestination;
    private String uiPath;
    private String hash;

    public UiStaticHandler() {
    }

    public UiStaticHandler(String uiFinalDestination, String uiPath, String hash) {
        this.uiFinalDestination = uiFinalDestination;
        this.uiPath = uiPath;
        this.hash = hash;
    }

    public String getUiFinalDestination() {
        return this.uiFinalDestination;
    }

    public void setUiFinalDestination(String uiFinalDestination) {
        this.uiFinalDestination = uiFinalDestination;
    }

    public String getUiPath() {
        return this.uiPath;
    }

    public void setUiPath(String uiPath) {
        this.uiPath = uiPath;
    }

    public void handle(RoutingContext event) {
        StaticHandler staticHandler = StaticHandler.create().setAllowRootFileSystemAccess(true).setWebRoot(this.uiFinalDestination).setDefaultContentEncoding("UTF-8");
        event.response().headers().set(HttpHeaders.ETAG, (CharSequence)this.hash);
        if (event.normalisedPath().length() == this.uiPath.length()) {
            event.response().setStatusCode(302);
            event.response().headers().set(HttpHeaders.LOCATION, (CharSequence)(this.uiPath + "/"));
            event.response().end();
            return;
        }
        if (event.normalisedPath().length() == this.uiPath.length() + 1) {
            event.reroute(this.uiPath + "/index.html");
            return;
        }
        staticHandler.handle((Object)event);
    }
}

