/*
 * Decompiled with CFR 0.152.
 */
package cn.cla.round.view.drawable;

import android.graphics.Rect;
import android.graphics.drawable.GradientDrawable;
import cn.cla.round.view.entity.ClaRoundViewBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0006J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcn/cla/round/view/drawable/ClaRoundDrawable;", "Landroid/graphics/drawable/GradientDrawable;", "builder", "Lcn/cla/round/view/entity/ClaRoundViewBuilder;", "(Lcn/cla/round/view/entity/ClaRoundViewBuilder;)V", "onBoundsChange", "", "r", "Landroid/graphics/Rect;", "setColor", "argb", "", "setCornerRadii", "radii", "", "setCornerRadius", "radius", "", "setRoundAndColor", "setStroke", "width", "color", "round_release"})
public final class ClaRoundDrawable
extends GradientDrawable {
    @NotNull
    private final ClaRoundViewBuilder builder;

    public ClaRoundDrawable(@NotNull ClaRoundViewBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.builder = builder;
    }

    public final void setRoundAndColor() {
        this.setColor(0);
        this.setStroke(0, 0);
        this.setCornerRadii(null);
        this.setCornerRadius(0.0f);
    }

    public void setColor(int argb) {
        if (this.builder.getHasBgColor$round_release()) {
            super.setColor(this.builder.getABgColor$round_release());
            return;
        }
        super.setColor(argb);
    }

    public void setStroke(int width, int color) {
        if (this.builder.getHasBorder$round_release()) {
            super.setStroke(MathKt.roundToInt((float)this.builder.getBorderWidth()), this.builder.getABorderColor$round_release(), this.builder.getDashWidth(), this.builder.getDashGap());
            return;
        }
        super.setStroke(width, color);
    }

    public void setCornerRadii(@Nullable float[] radii) {
        if (this.builder.getHasAllRadius$round_release()) {
            super.setCornerRadius(this.builder.getRadius());
            return;
        }
        if (this.builder.getHasSingleRadius$round_release()) {
            super.setCornerRadii(this.builder.getRadii$round_release());
            return;
        }
        super.setCornerRadii(radii);
    }

    public void setCornerRadius(float radius) {
        if (this.builder.getHasAllRadius$round_release()) {
            super.setCornerRadius(this.builder.getRadius());
            return;
        }
        if (this.builder.getHasSingleRadius$round_release()) {
            super.setCornerRadii(this.builder.getRadii$round_release());
            return;
        }
        super.setCornerRadius(radius);
    }

    protected void onBoundsChange(@NotNull Rect r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        super.onBoundsChange(r);
        if (this.builder.getRadiusAdjust$round_release()) {
            this.setCornerRadius(RangesKt.coerceAtMost((int)r.width(), (int)r.height()) / 2);
        }
    }
}

