/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.pepper.csv;

import eu.solven.pepper.csv.IZeroCopyCSVParser;
import eu.solven.pepper.csv.IZeroCopyConsumer;
import eu.solven.pepper.primitive.Jdk9CharSequenceParsers;
import eu.solven.pepper.primitive.PepperParserHelper;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.CharBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.LongConsumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCopyCSVParser
implements IZeroCopyCSVParser {
    private static final int DEFAULT_RADIX = 10;
    protected static final Logger LOGGER = LoggerFactory.getLogger(ZeroCopyCSVParser.class);
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    protected final int bufferSize;

    public ZeroCopyCSVParser() {
        this.bufferSize = 1024;
    }

    public ZeroCopyCSVParser(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public void parse(Reader reader, char separator, List<IZeroCopyConsumer> consumers) throws IOException {
        consumers.stream().filter(Objects::nonNull).forEach(consumer -> {
            if (consumer instanceof IntConsumer) {
                LOGGER.trace("We like IntConsumer");
            } else if (consumer instanceof LongConsumer) {
                LOGGER.trace("We like LongConsumer");
            } else if (consumer instanceof DoubleConsumer) {
                LOGGER.trace("We like DoubleConsumer");
            } else if (consumer instanceof Consumer) {
                LOGGER.trace("We hope it is a Consumer<CharSequence>");
            } else {
                throw new IllegalArgumentException("You need to be any java.util.function.*Consumer");
            }
        });
        IntFunction<IZeroCopyConsumer> indexToConsumer = index -> {
            if (index < consumers.size()) {
                return (IZeroCopyConsumer)consumers.get(index);
            }
            return null;
        };
        CharBuffer charBuffer = CharBuffer.allocate(this.bufferSize);
        CharBuffer nextValue = CharBuffer.allocate(this.bufferSize);
        charBuffer.position(charBuffer.limit());
        boolean moreToRead = true;
        int columnIndex = -1;
        char[] buffer = new char[charBuffer.capacity()];
        while (moreToRead) {
            charBuffer.compact();
            int nbRead = reader.read(buffer, 0, Math.min(buffer.length, charBuffer.remaining()));
            if (nbRead > 0) {
                charBuffer.put(buffer, 0, nbRead);
            }
            if (nbRead == 0) {
                throw new IllegalStateException("Unable to read data");
            }
            charBuffer.flip();
            if (nbRead < 0) {
                moreToRead = false;
            }
            while (charBuffer.hasRemaining()) {
                char nextChar = charBuffer.get();
                if (nextChar == separator) {
                    columnIndex = this.flushColumn(indexToConsumer, nextValue, columnIndex, true);
                    continue;
                }
                if (nextChar == '\r' || nextChar == '\n') {
                    columnIndex = this.flushColumn(indexToConsumer, nextValue, columnIndex, false);
                    this.warnConsumersWithoutColumn(indexToConsumer, columnIndex, consumers.size());
                    columnIndex = -1;
                    continue;
                }
                if (columnIndex < 0 && nextValue.position() == 0) {
                    ++columnIndex;
                }
                nextValue.put(nextChar);
            }
            if (moreToRead) continue;
            columnIndex = this.flushColumn(indexToConsumer, nextValue, columnIndex, false);
            this.warnConsumersWithoutColumn(indexToConsumer, columnIndex, consumers.size());
        }
    }

    public Stream<String[]> parseAsStringArrays(Reader reader, char separator) {
        CharBuffer charBuffer = CharBuffer.allocate(this.bufferSize);
        charBuffer.position(charBuffer.limit());
        AtomicBoolean moreToRead = new AtomicBoolean(true);
        AtomicInteger columnIndex = new AtomicInteger(0);
        char[] buffer = new char[charBuffer.capacity()];
        CharBuffer nextValue = CharBuffer.allocate(this.bufferSize);
        LinkedList pendingStrings = new LinkedList();
        Youpi consumer = new Youpi(pendingStrings);
        IntFunction<IZeroCopyConsumer> indexToConsumer = index -> consumer;
        return StreamSupport.stream(new CsvSpliterator(Long.MAX_VALUE, 0, buffer, separator, charBuffer, pendingStrings, nextValue, indexToConsumer, reader, columnIndex, moreToRead), false);
    }

    protected void warnConsumersWithoutColumn(IntFunction<IZeroCopyConsumer> consumers, int columnIndex, int maxIndex) {
        if (columnIndex < 0) {
            return;
        }
        for (int i = columnIndex; i < maxIndex; ++i) {
            IZeroCopyConsumer consumer = consumers.apply(i);
            if (consumer == null) continue;
            consumer.nextRowIsMissing();
        }
    }

    protected int flushColumn(IntFunction<IZeroCopyConsumer> consumers, CharBuffer nextValue, int flushedColumnIndex, boolean hasMoreSameRow) {
        if (flushedColumnIndex <= -1) {
            assert (nextValue.position() == 0);
            if (hasMoreSameRow) {
                IZeroCopyConsumer consumer = consumers.apply(0);
                if (consumer != null) {
                    consumer.nextRowIsMissing();
                }
                return 1;
            }
            return -1;
        }
        nextValue.flip();
        IZeroCopyConsumer consumer = consumers.apply(flushedColumnIndex);
        if (consumer != null) {
            if (nextValue.hasRemaining()) {
                this.flushContent(consumer, nextValue, flushedColumnIndex);
            } else {
                consumer.nextRowIsMissing();
            }
        }
        nextValue.limit(nextValue.position());
        nextValue.compact();
        return flushedColumnIndex + 1;
    }

    protected void flushContent(IZeroCopyConsumer consumer, CharSequence charBuffer, int columnIndex) {
        block14: {
            if (consumer == null) {
                return;
            }
            CharSequence subSequence = charBuffer;
            try {
                if (consumer instanceof IntConsumer) {
                    if (subSequence.length() == 0) {
                        consumer.nextRowIsMissing();
                    } else {
                        ((IntConsumer)((Object)consumer)).accept(Jdk9CharSequenceParsers.parseInt((CharSequence)subSequence, (int)0, (int)charBuffer.length(), (int)10));
                    }
                    break block14;
                }
                if (consumer instanceof LongConsumer) {
                    if (subSequence.length() == 0) {
                        consumer.nextRowIsMissing();
                    } else {
                        ((LongConsumer)((Object)consumer)).accept(Jdk9CharSequenceParsers.parseLong((CharSequence)subSequence, (int)0, (int)charBuffer.length(), (int)10));
                    }
                    break block14;
                }
                if (consumer instanceof DoubleConsumer) {
                    if (subSequence.length() == 0) {
                        consumer.nextRowIsMissing();
                    } else {
                        ((DoubleConsumer)((Object)consumer)).accept(PepperParserHelper.parseDouble((CharSequence)subSequence));
                    }
                    break block14;
                }
                if (consumer instanceof Consumer) {
                    ((Consumer)((Object)consumer)).accept(subSequence);
                    break block14;
                }
                throw new IllegalArgumentException("Not a consumer ?!");
            }
            catch (NumberFormatException e) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Ouch on " + subSequence, (Throwable)e);
                }
                consumer.nextRowIsInvalid(subSequence);
            }
        }
    }

    private final class Youpi
    implements IZeroCopyConsumer,
    Consumer<CharSequence> {
        private final List<String> pendingStrings;

        private Youpi(List<String> pendingStrings) {
            this.pendingStrings = pendingStrings;
        }

        @Override
        public void nextRowIsMissing() {
            this.pendingStrings.add("");
        }

        @Override
        public void nextRowIsInvalid(CharSequence charSequence) {
            this.pendingStrings.add(charSequence.toString());
        }

        @Override
        public void accept(CharSequence t) {
            this.pendingStrings.add(t.toString());
        }
    }

    private final class CsvSpliterator
    extends Spliterators.AbstractSpliterator<String[]> {
        private final char[] buffer;
        private final char separator;
        private final CharBuffer charBuffer;
        private final List<String> pendingStrings;
        private final CharBuffer nextValue;
        private final IntFunction<IZeroCopyConsumer> indexToConsumer;
        private final Reader reader;
        private final AtomicInteger columnIndex;
        private final AtomicBoolean moreToRead;

        private CsvSpliterator(long est, int additionalCharacteristics, char[] buffer, char separator, CharBuffer charBuffer, List<String> pendingStrings, CharBuffer nextValue, IntFunction<IZeroCopyConsumer> indexToConsumer, Reader reader, AtomicInteger columnIndex, AtomicBoolean moreToRead) {
            super(est, additionalCharacteristics);
            this.buffer = buffer;
            this.separator = separator;
            this.charBuffer = charBuffer;
            this.pendingStrings = pendingStrings;
            this.nextValue = nextValue;
            this.indexToConsumer = indexToConsumer;
            this.reader = reader;
            this.columnIndex = columnIndex;
            this.moreToRead = moreToRead;
        }

        @Override
        public boolean tryAdvance(Consumer<? super String[]> action) {
            boolean actionHasBeenTriggered = false;
            while ((this.moreToRead.get() || this.charBuffer.hasRemaining()) && !actionHasBeenTriggered) {
                this.fillBuffer(this.reader, this.charBuffer, this.moreToRead, this.buffer);
                while (this.charBuffer.hasRemaining() && !actionHasBeenTriggered) {
                    actionHasBeenTriggered = this.processBuffer(this.separator, this.charBuffer, this.columnIndex, this.nextValue, this.pendingStrings, this.indexToConsumer, action);
                }
                if (this.moreToRead.get() || this.charBuffer.hasRemaining() || actionHasBeenTriggered) continue;
                this.columnIndex.set(ZeroCopyCSVParser.this.flushColumn(this.indexToConsumer, this.nextValue, this.columnIndex.get(), false));
                ZeroCopyCSVParser.this.warnConsumersWithoutColumn(this.indexToConsumer, this.columnIndex.get(), -1);
            }
            return actionHasBeenTriggered;
        }

        protected void fillBuffer(Reader reader, CharBuffer charBuffer, AtomicBoolean moreToRead, char ... buffer) {
            if (moreToRead.get() && !charBuffer.hasRemaining()) {
                int nbRead;
                charBuffer.compact();
                try {
                    nbRead = reader.read(buffer, 0, Math.min(buffer.length, charBuffer.remaining()));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                if (nbRead > 0) {
                    charBuffer.put(buffer, 0, nbRead);
                }
                if (nbRead == 0) {
                    throw new IllegalStateException("Unable to read data");
                }
                charBuffer.flip();
                if (nbRead < 0) {
                    moreToRead.set(false);
                }
            }
        }

        protected boolean processBuffer(char separator, CharBuffer charBuffer, AtomicInteger columnIndex, CharBuffer nextValue, List<String> pendingStrings, IntFunction<IZeroCopyConsumer> indexToConsumer, Consumer<? super String[]> action) {
            boolean actionHasBeenTriggered = false;
            char nextChar = charBuffer.get();
            if (nextChar == separator) {
                columnIndex.set(ZeroCopyCSVParser.this.flushColumn(indexToConsumer, nextValue, columnIndex.get(), true));
            } else if (nextChar == '\r' || nextChar == '\n') {
                columnIndex.set(ZeroCopyCSVParser.this.flushColumn(indexToConsumer, nextValue, columnIndex.get(), false));
                ZeroCopyCSVParser.this.warnConsumersWithoutColumn(indexToConsumer, columnIndex.get(), -1);
                if (!pendingStrings.isEmpty()) {
                    if (action != null) {
                        action.accept((String[])pendingStrings.toArray(new String[0]));
                    }
                    pendingStrings.clear();
                    actionHasBeenTriggered = true;
                }
                columnIndex.set(-1);
            } else {
                if (columnIndex.get() < 0 && nextValue.position() == 0) {
                    columnIndex.incrementAndGet();
                }
                nextValue.put(nextChar);
            }
            return actionHasBeenTriggered;
        }
    }
}

