/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.pepper.csv.writer;

import com.google.common.base.Joiner;
import eu.solven.pepper.csv.writer.IZeroCopyCSVWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCopyCSVWriter
implements IZeroCopyCSVWriter {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ZeroCopyCSVWriter.class);
    public static final char DEFAULT_SEPARATOR = ';';
    public static final String DEFAULT_NEWLINE = "\r\n";
    protected final Writer writer;
    protected final Appendable proxy;
    protected final String separator;
    protected final String newLine;
    protected final AtomicLong nbCharWritten = new AtomicLong();
    protected final AtomicLong nbLinesWritten = new AtomicLong();
    protected final String filenameForOutput;

    public ZeroCopyCSVWriter(Writer writer, String filenameForOutput) {
        this(writer, filenameForOutput, ';', DEFAULT_NEWLINE);
    }

    public ZeroCopyCSVWriter(Writer writer, String filenameForOutput, char separator, String newLine) {
        this(writer, filenameForOutput, String.valueOf(separator), newLine);
    }

    public ZeroCopyCSVWriter(Writer writer, String filenameForOutput, String separator, String newLine) {
        this.writer = writer;
        this.proxy = this.makeProxy(writer);
        this.filenameForOutput = filenameForOutput;
        this.separator = separator;
        this.newLine = newLine;
    }

    protected final Appendable makeProxy(final Appendable writer) {
        return new Appendable(){

            @Override
            public Appendable append(CharSequence csq, int start, int end) throws IOException {
                ZeroCopyCSVWriter.this.nbCharWritten.addAndGet(end - start);
                return writer.append(csq, start, end);
            }

            @Override
            public Appendable append(char c) throws IOException {
                ZeroCopyCSVWriter.this.nbCharWritten.incrementAndGet();
                return writer.append(c);
            }

            @Override
            public Appendable append(CharSequence csq) throws IOException {
                ZeroCopyCSVWriter.this.nbCharWritten.addAndGet(csq.length());
                return writer.append(csq);
            }
        };
    }

    @Override
    public long applyAsLong(Stream<?> input) {
        Joiner joiner = Joiner.on((String)this.separator).useForNull("");
        try {
            AtomicLong nbRows = new AtomicLong();
            Stream<CharSequence> escaped = input.filter(Objects::nonNull).map(part -> {
                CharSequence asCharSequence = part instanceof CharSequence ? (CharSequence)part : part.toString();
                if (this.contains(asCharSequence, this.separator) || this.contains(asCharSequence, this.newLine)) {
                    return "\"" + asCharSequence + "\"";
                }
                return asCharSequence;
            }).peek(cs -> nbRows.incrementAndGet());
            Appendable output = joiner.appendTo(this.proxy, escaped.iterator());
            assert (output.equals(this.proxy));
            this.writer.write(this.newLine);
            this.nbLinesWritten.incrementAndGet();
            return nbRows.get();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean contains(CharSequence containined, CharSequence contained) {
        if (containined == null || contained == null) {
            return false;
        }
        return containined.toString().contains(contained.toString());
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOGGER.info("We wrote {} chars for {} rows in '{}'", new Object[]{this.getNbCharsWritten(), this.getNbLinesWritten(), this.filenameForOutput});
    }

    public Writer getWriter() {
        return this.writer;
    }

    public long getNbCharsWritten() {
        return this.nbCharWritten.get();
    }

    public long getNbLinesWritten() {
        return this.nbLinesWritten.get();
    }

    @Override
    public String getFilenameForOutput() {
        return this.filenameForOutput;
    }
}

