/*
 * Decompiled with CFR 0.152.
 */
package io.github.yggdrasil80.yggtools.redis;

import io.github.yggdrasil80.yggtools.redis.IChannel;
import io.github.yggdrasil80.yggtools.redis.IChannelDefault;
import io.github.yggdrasil80.yggtools.redis.PubSubManager;
import io.github.yggdrasil80.yggtools.redis.RedisManager;
import io.github.yggdrasil80.yggtools.redis.RedisManagerBuilder;
import io.github.yggdrasil80.yggtools.utils.BuilderArgument;
import io.github.yggdrasil80.yggtools.utils.IBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubSubManagerBuilder
implements IBuilder<PubSubManager> {
    private final BuilderArgument<RedisManager> redis = new BuilderArgument<RedisManager>("RedisManager", () -> new RedisManagerBuilder().build(), true);
    private final BuilderArgument<Enum<? extends IChannel>> channels = new BuilderArgument<Enum>("Channels", () -> IChannelDefault.DEFAULT, true);
    private final BuilderArgument<Enum<? extends IChannel>> patterns = new BuilderArgument<Enum>("Patterns", () -> IChannelDefault.DEFAULT_PATTERN, false);
    private final BuilderArgument<Logger> logger = new BuilderArgument<Logger>("Logger", () -> LoggerFactory.getLogger(PubSubManager.class), false);
    private final BuilderArgument<Boolean> debug = new BuilderArgument<Boolean>("Debug", () -> false, false);

    public PubSubManagerBuilder withRedis(RedisManager redis) {
        this.redis.set(redis);
        return this;
    }

    public PubSubManagerBuilder withChannels(Enum<? extends IChannel> channels) {
        this.channels.set(channels);
        return this;
    }

    public PubSubManagerBuilder withPatterns(Enum<? extends IChannel> patterns) {
        this.patterns.set(patterns);
        return this;
    }

    public PubSubManagerBuilder withLogger(Logger logger) {
        this.logger.set(logger);
        return this;
    }

    public PubSubManagerBuilder withDebug(boolean debug) {
        this.debug.set(debug);
        return this;
    }

    @Override
    public PubSubManager build() {
        return new PubSubManager(this.redis.get(), this.channels.get(), this.patterns.get(), this.logger.get(), this.debug.get());
    }
}

