/*
 * Decompiled with CFR 0.152.
 */
package io.github.yggdrasil80.yggtools.redis;

import io.github.yggdrasil80.yggtools.redis.PubSubManager;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisManager {
    private final String redisHost;
    private final int redisPort;
    private final String redisPass;
    private final int redisDB;
    private JedisPool jedisPool;
    private PubSubManager pubSub;
    private final Logger logger;

    public RedisManager(String redisHost, int redisPort, String redisPass, int redisDB, PubSubManager pubSub, Logger logger) {
        this.redisHost = redisHost;
        this.redisPort = redisPort;
        this.redisPass = redisPass;
        this.redisDB = redisDB;
        this.pubSub = pubSub;
        this.logger = logger;
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    public void start() {
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.redisHost, this.redisPort, 2000, this.redisPass, this.redisDB, this.getClass().getSimpleName());
        try (Jedis jedis = this.jedisPool.getResource();){
            this.logger.info("Connection set with Redis, on database " + jedis.getDB());
        }
        catch (Exception e) {
            this.logger.error("An error occurred during connecting to Redis ! (" + e.getMessage() + "). Shutdown...");
        }
        if (this.pubSub != null) {
            this.pubSub.start();
        }
    }

    public void stop() {
        this.logger.info("Stopping Redis connection...");
        if (this.pubSub != null) {
            this.pubSub.stop();
        }
        this.jedisPool.close();
        this.jedisPool.destroy();
    }

    public Jedis getJedis() {
        return this.jedisPool.getResource();
    }
}

