/*
 * Decompiled with CFR 0.152.
 */
package com.passerby.recyclerviewlib.recycler.adapter;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.passerby.recyclerviewlib.recycler.adapter.CheckableRvHolder;
import com.passerby.recyclerviewlib.recycler.adapter.OnItemCheckListener;
import com.passerby.recyclerviewlib.recycler.adapter.RvAdapter;
import com.passerby.recyclerviewlib.recycler.adapter.RvHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;

public abstract class CheckableRvAdapter<Item, Holder extends CheckableRvHolder<Item>>
extends RvAdapter<Item, Holder> {
    private static final String TAG = "CheckableRvAdapter";
    private final WeakHashMap<Item, State<Item>> stateCache = new WeakHashMap();
    private final List<OnItemCheckListener<Item>> onItemCheckListeners = new ArrayList<OnItemCheckListener<Item>>();
    private int maxCheckCount;

    public CheckableRvAdapter(@NonNull Context context) {
        super(context);
    }

    public CheckableRvAdapter(@NonNull Context context, int maxCheckCount) {
        super(context);
        this.maxCheckCount = maxCheckCount;
    }

    @Override
    protected void onBindHolder(@NonNull Holder holder, int position, List<Object> payloads) {
        Object item = this.getItem(position);
        ((RvHolder)((Object)holder)).onBind(item, position);
        if (payloads == null || payloads.isEmpty()) {
            ((CheckableRvHolder)((Object)holder)).onUpdate(item, position, this.isCheckedItem(item));
            this.onUpdate(holder, item, position, this.isCheckedItem(item));
        } else {
            ((CheckableRvHolder)((Object)holder)).onUpdate(item, position, this.isCheckedItem(item), payloads);
            this.onUpdate(holder, item, position, this.isCheckedItem(item), payloads);
        }
    }

    @Override
    @Deprecated
    protected final void onUpdate(@NonNull Holder holder, @NonNull Item item, int position) {
        super.onUpdate(holder, item, position);
    }

    @Override
    @Deprecated
    protected final void onUpdate(@NonNull Holder holder, @NonNull Item item, int position, List<Object> payloads) {
        super.onUpdate(holder, item, position, payloads);
    }

    protected void onUpdate(@NonNull Holder holder, @NonNull Item item, int position, boolean isChecked) {
    }

    protected void onUpdate(@NonNull Holder holder, @NonNull Item item, int position, boolean isChecked, List<Object> payloads) {
    }

    protected boolean onItemCheckChange(@NonNull Item item, int position, boolean checked) {
        return true;
    }

    @Override
    public Item setItem(int index, Item item) {
        Item oldItem = super.setItem(index, item);
        this.removeState(oldItem);
        return oldItem;
    }

    @Override
    public List<Item> setItems(int startIndex, List<Item> items) {
        List<Item> olds = super.setItems(startIndex, items);
        this.removeStates(olds);
        return olds;
    }

    @Override
    public Item removeItem(int index) {
        int removed = super.removeItem(index);
        this.removeState(removed);
        return removed;
    }

    @Override
    public Item removeItem(Item item) {
        this.removeState(item);
        return super.removeItem(item);
    }

    @Override
    public List<Item> removeItems(List<Item> items) {
        this.removeStates(items);
        return super.removeItems(items);
    }

    @Override
    public void clearItems() {
        this.clearChecked();
        super.clearItems();
    }

    private void putState(Item item) {
        this.stateCache.put(item, new State<Item>(item, true));
    }

    private void removeState(Item item) {
        this.stateCache.remove(item);
    }

    private void removeStates(List<Item> items) {
        for (Item item : items) {
            this.removeState(item);
        }
    }

    public void setMaxCheckCount(int checkCount) {
        this.maxCheckCount = checkCount;
    }

    public int getMaxCheckCount() {
        return this.maxCheckCount;
    }

    private boolean isSingleMode() {
        return this.maxCheckCount == 1;
    }

    public boolean setChecked(Item item, boolean isChecked) {
        if (item == null) {
            Log.e((String)TAG, (String)"setChecked: item is null");
            return false;
        }
        if (this.getMaxCheckCount() == 0) {
            Log.e((String)TAG, (String)"setChecked: maxCheckCount is zero");
            return false;
        }
        int position = this.getItemPosition(item);
        if (!this.checkListenerOpinion(item, position, isChecked) || !this.onItemCheckChange(item, position, isChecked)) {
            Log.d((String)TAG, (String)"setChecked: check operation did not pass");
            return false;
        }
        if (position != -1) {
            if (isChecked) {
                if (this.isCheckedItem(item)) {
                    Log.e((String)TAG, (String)"setChecked: item is already checked");
                    return false;
                }
                if (this.getCheckedSize() >= this.getMaxCheckCount()) {
                    Log.e((String)TAG, (String)("setChecked: over checkCount, because checkedSize = " + this.getCheckedSize() + ", maxCheckCount = " + this.getMaxCheckCount()));
                    return false;
                }
                this.putState(item);
            } else {
                if (this.stateCache.get(item) == null) {
                    Log.e((String)TAG, (String)"setChecked: item uncheck fail, because not exist");
                    return false;
                }
                this.removeState(item);
                this.notifyItemChanged(position);
            }
            return true;
        }
        Log.e((String)TAG, (String)"setChecked: not found item");
        return false;
    }

    public boolean setChecked(int position, boolean isChecked) {
        return this.setChecked(this.getItem(position), isChecked);
    }

    public boolean setChecked(@NonNull List<Item> items, boolean isChecked) {
        if (this.getCheckedSize() >= this.getMaxCheckCount()) {
            Log.e((String)TAG, (String)("setChecked: over checkCount, because checkedSize = " + this.getCheckedSize() + ", maxCheckCount = " + this.getMaxCheckCount()));
            return false;
        }
        if (this.getMaxCheckCount() < items.size()) {
            Log.e((String)TAG, (String)("setChecked: over checkCount, because items.size = " + items.size() + ", maxCheckCount = " + this.getMaxCheckCount()));
            return false;
        }
        boolean result = false;
        for (Item item : items) {
            result |= this.setChecked(item, isChecked);
        }
        return result;
    }

    public boolean setChecked(boolean isChecked, int ... positions) {
        boolean result = false;
        for (int position : positions) {
            result |= this.setChecked(this.getItem(position), isChecked);
        }
        return result;
    }

    public void clearChecked() {
        for (Item item : this.stateCache.keySet()) {
            this.setChecked(item, false);
        }
        this.stateCache.clear();
    }

    public int getCheckedSize() {
        return this.stateCache.size();
    }

    public List<Item> getCheckedItems() {
        return new ArrayList<Item>(this.stateCache.keySet());
    }

    public List<Integer> getCheckedPositions() {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (Item item : this.stateCache.keySet()) {
            int position = this.getItemPosition(item);
            if (position < 0) continue;
            positions.add(position);
        }
        return positions;
    }

    public boolean isCheckedPosition(int position) {
        return this.isCheckedItem(this.getItem(position));
    }

    public boolean isCheckedItem(Item item) {
        return this.stateCache.containsKey(item);
    }

    public void addOnItemCheckListener(OnItemCheckListener<Item> listener) {
        if (!this.onItemCheckListeners.contains(listener)) {
            this.onItemCheckListeners.add(listener);
        }
    }

    public void removeOnItemCheckListener(OnItemCheckListener<Item> listener) {
        this.onItemCheckListeners.remove(listener);
    }

    private boolean checkListenerOpinion(Item item, int position, boolean checked) {
        boolean result = true;
        for (OnItemCheckListener<Item> listener : this.onItemCheckListeners) {
            result &= listener.onItemCheckChange(item, position, checked);
        }
        return result;
    }

    private static class State<Item> {
        private Item item;
        private boolean isChecked;

        private State(Item item, boolean isChecked) {
            this.item = item;
            this.isChecked = isChecked;
        }

        public Item getItem() {
            return this.item;
        }

        public boolean isChecked() {
            return this.isChecked;
        }
    }
}

