/*
 * Decompiled with CFR 0.152.
 */
package com.passerby.recyclerviewlib.recycler.adapter;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.passerby.recyclerviewlib.recycler.adapter.NestableRvAdapter;
import com.passerby.recyclerviewlib.recycler.adapter.PositionRange;
import com.passerby.recyclerviewlib.recycler.adapter.RvAdapter;
import com.passerby.recyclerviewlib.recycler.adapter.RvHolder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

class NestableAdapterController<Adapter extends NestableRvAdapter<?, RvHolder<?>>>
extends RecyclerView.AdapterDataObserver {
    private static final int UPDATE_POSITION_RANGE_ADD_OP = 0;
    private static final int UPDATE_POSITION_RANGE_MINUS_OP = 1;
    private PositionRange localPositionRange;
    private PositionRange globalPositionRange;
    private final Adapter attachedAdapter;
    private final List<RecyclerView.AdapterDataObserver> localAdapterDataObservers = new ArrayList<RecyclerView.AdapterDataObserver>();
    private final HashSet<Integer> itemTypeStore = new HashSet();
    private String initiatorAdapterId;
    private boolean suspend;

    public NestableAdapterController(Adapter attachedAdapter) {
        this.attachedAdapter = attachedAdapter;
        attachedAdapter.registerAdapterDataObserver((RecyclerView.AdapterDataObserver)this);
        this.reboot();
    }

    void reboot() {
        this.localPositionRange = new PositionRange(0, ((RvAdapter)((Object)this.attachedAdapter)).getItemSize());
        this.globalPositionRange = this.getGlobalPositionRange(((NestableRvAdapter)((Object)this.attachedAdapter)).getRootAdapter(), 0);
    }

    void dispose() {
        this.localPositionRange = new PositionRange(0, ((RvAdapter)((Object)this.attachedAdapter)).getItemSize());
        this.globalPositionRange = this.getGlobalPositionRange(((NestableRvAdapter)((Object)this.attachedAdapter)).getRootAdapter(), 0);
    }

    void suspend() {
        this.suspend = true;
    }

    boolean isSuspend() {
        try {
            boolean bl = this.suspend;
            return bl;
        }
        finally {
            this.suspend = false;
        }
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void onChanged() {
        NestableRvAdapter<?, RvHolder<?>> rootAdapter = ((NestableRvAdapter)((Object)this.attachedAdapter)).getRootAdapter();
        if (rootAdapter == this.attachedAdapter && this.isInitiatorEmpty()) {
            this.initiatorAdapterId = ((NestableRvAdapter)((Object)this.attachedAdapter)).getAdapterId();
        }
        if (rootAdapter != this.attachedAdapter && this.isInitiatorEmpty()) {
            rootAdapter.adapterController.initiatorAdapterId = ((NestableRvAdapter)((Object)this.attachedAdapter)).getAdapterId();
            rootAdapter.notifyDataSetChanged();
        } else {
            if (!this.isSuspend() && this.isInitiator()) {
                for (RecyclerView.AdapterDataObserver observer : this.localAdapterDataObservers) {
                    observer.onChanged();
                }
            }
            this.notifyChildrenDataSetChanged((NestableRvAdapter<?, RvHolder<?>>)((Object)this.attachedAdapter), this.resetInitiator(), adapter -> adapter.notifyDataSetChanged());
        }
    }

    public void onItemRangeChanged(int positionStart, int itemCount) {
        NestableRvAdapter<?, RvHolder<?>> rootAdapter = ((NestableRvAdapter)((Object)this.attachedAdapter)).getRootAdapter();
        if (rootAdapter == this.attachedAdapter && this.isInitiatorEmpty()) {
            this.initiatorAdapterId = ((NestableRvAdapter)((Object)this.attachedAdapter)).getAdapterId();
        }
        if (rootAdapter != this.attachedAdapter && this.isInitiatorEmpty()) {
            rootAdapter.adapterController.initiatorAdapterId = ((NestableRvAdapter)((Object)this.attachedAdapter)).getAdapterId();
            rootAdapter.notifyItemRangeChanged(this.convertGlobalPosition(positionStart), itemCount);
        } else {
            if (!this.isSuspend() && this.globalPositionRange.contains(positionStart)) {
                for (RecyclerView.AdapterDataObserver observer : this.localAdapterDataObservers) {
                    observer.onItemRangeChanged(positionStart, itemCount);
                }
            }
            this.notifyChildrenDataSetChanged((NestableRvAdapter<?, RvHolder<?>>)((Object)this.attachedAdapter), this.resetInitiator(), adapter -> adapter.notifyItemRangeChanged(positionStart, itemCount));
        }
    }

    public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
        NestableRvAdapter<?, RvHolder<?>> rootAdapter = ((NestableRvAdapter)((Object)this.attachedAdapter)).getRootAdapter();
        if (rootAdapter == this.attachedAdapter && this.isInitiatorEmpty()) {
            this.initiatorAdapterId = ((NestableRvAdapter)((Object)this.attachedAdapter)).getAdapterId();
        }
        if (rootAdapter != this.attachedAdapter && this.isInitiatorEmpty()) {
            rootAdapter.adapterController.initiatorAdapterId = ((NestableRvAdapter)((Object)this.attachedAdapter)).getAdapterId();
            rootAdapter.notifyItemRangeChanged(this.convertGlobalPosition(positionStart), itemCount, payload);
        } else {
            if (!this.isSuspend() && this.globalPositionRange.contains(positionStart)) {
                for (RecyclerView.AdapterDataObserver observer : this.localAdapterDataObservers) {
                    observer.onItemRangeChanged(positionStart, itemCount, payload);
                }
            }
            this.notifyChildrenDataSetChanged((NestableRvAdapter<?, RvHolder<?>>)((Object)this.attachedAdapter), this.resetInitiator(), adapter -> adapter.notifyItemRangeChanged(positionStart, itemCount, payload));
        }
    }

    public void onItemRangeInserted(int positionStart, int itemCount) {
        NestableRvAdapter<?, RvHolder<?>> rootAdapter = ((NestableRvAdapter)((Object)this.attachedAdapter)).getRootAdapter();
        if (rootAdapter == this.attachedAdapter && this.isInitiatorEmpty()) {
            this.initiatorAdapterId = ((NestableRvAdapter)((Object)this.attachedAdapter)).getAdapterId();
        }
        if (rootAdapter != this.attachedAdapter && this.isInitiatorEmpty()) {
            rootAdapter.adapterController.initiatorAdapterId = ((NestableRvAdapter)((Object)this.attachedAdapter)).getAdapterId();
            rootAdapter.notifyItemRangeInserted(this.convertGlobalPosition(positionStart), itemCount);
        } else {
            if (!this.isSuspend()) {
                this.updatePositionRange(0, this.isInitiator(), positionStart, itemCount);
                if (this.globalPositionRange.contains(positionStart)) {
                    for (RecyclerView.AdapterDataObserver observer : this.localAdapterDataObservers) {
                        observer.onItemRangeInserted(positionStart, itemCount);
                    }
                }
            }
            this.notifyChildrenDataSetChanged((NestableRvAdapter<?, RvHolder<?>>)((Object)this.attachedAdapter), this.resetInitiator(), adapter -> adapter.notifyItemRangeInserted(positionStart, itemCount));
        }
    }

    public void onItemRangeRemoved(int positionStart, int itemCount) {
        NestableRvAdapter<?, RvHolder<?>> rootAdapter = ((NestableRvAdapter)((Object)this.attachedAdapter)).getRootAdapter();
        if (rootAdapter == this.attachedAdapter && this.isInitiatorEmpty()) {
            this.initiatorAdapterId = ((NestableRvAdapter)((Object)this.attachedAdapter)).getAdapterId();
        }
        if (rootAdapter != this.attachedAdapter && this.isInitiatorEmpty()) {
            rootAdapter.adapterController.initiatorAdapterId = ((NestableRvAdapter)((Object)this.attachedAdapter)).getAdapterId();
            rootAdapter.notifyItemRangeRemoved(this.convertGlobalPosition(positionStart), itemCount);
        } else {
            if (!this.isSuspend()) {
                this.updatePositionRange(1, this.isInitiator(), positionStart, itemCount);
                if (this.globalPositionRange.contains(positionStart)) {
                    for (RecyclerView.AdapterDataObserver observer : this.localAdapterDataObservers) {
                        observer.onItemRangeRemoved(positionStart, itemCount);
                    }
                }
            }
            this.notifyChildrenDataSetChanged((NestableRvAdapter<?, RvHolder<?>>)((Object)this.attachedAdapter), this.resetInitiator(), adapter -> adapter.notifyItemRangeRemoved(positionStart, itemCount));
        }
    }

    public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
        NestableRvAdapter<?, RvHolder<?>> rootAdapter = ((NestableRvAdapter)((Object)this.attachedAdapter)).getRootAdapter();
        if (rootAdapter == this.attachedAdapter && this.isInitiatorEmpty()) {
            this.initiatorAdapterId = ((NestableRvAdapter)((Object)this.attachedAdapter)).getAdapterId();
        }
        if (rootAdapter != this.attachedAdapter && this.isInitiatorEmpty()) {
            rootAdapter.adapterController.initiatorAdapterId = ((NestableRvAdapter)((Object)this.attachedAdapter)).getAdapterId();
            rootAdapter.notifyItemMoved(this.convertGlobalPosition(fromPosition), this.convertGlobalPosition(toPosition));
        } else {
            if (this.globalPositionRange.contains(fromPosition) && this.globalPositionRange.contains(toPosition)) {
                for (RecyclerView.AdapterDataObserver observer : this.localAdapterDataObservers) {
                    observer.onItemRangeMoved(fromPosition, toPosition, itemCount);
                }
            }
            this.notifyChildrenDataSetChanged((NestableRvAdapter<?, RvHolder<?>>)((Object)this.attachedAdapter), this.resetInitiator(), adapter -> adapter.notifyItemMoved(fromPosition, toPosition));
        }
    }

    public void onStateRestorationPolicyChanged() {
        NestableRvAdapter<?, RvHolder<?>> rootAdapter = ((NestableRvAdapter)((Object)this.attachedAdapter)).getRootAdapter();
        if (rootAdapter == this.attachedAdapter && this.isInitiatorEmpty()) {
            this.initiatorAdapterId = ((NestableRvAdapter)((Object)this.attachedAdapter)).getAdapterId();
        }
        if (rootAdapter != this.attachedAdapter && this.isInitiatorEmpty()) {
            rootAdapter.adapterController.initiatorAdapterId = ((NestableRvAdapter)((Object)this.attachedAdapter)).getAdapterId();
            rootAdapter.setStateRestorationPolicy(this.attachedAdapter.getStateRestorationPolicy());
        } else {
            if (!this.isSuspend()) {
                for (RecyclerView.AdapterDataObserver observer : this.localAdapterDataObservers) {
                    observer.onStateRestorationPolicyChanged();
                }
            }
            this.notifyChildrenDataSetChanged((NestableRvAdapter<?, RvHolder<?>>)((Object)this.attachedAdapter), this.resetInitiator(), adapter -> adapter.setStateRestorationPolicy(this.attachedAdapter.getStateRestorationPolicy()));
        }
    }

    private void notifyChildrenDataSetChanged(@NonNull NestableRvAdapter<?, RvHolder<?>> notifyAdapter, String initiatorAdapterId, @NonNull OnNotifyChangeAction action) {
        if (notifyAdapter.getChildrenAdapterCount() != 0) {
            for (NestableRvAdapter<?, RvHolder<?>> childAdapter : notifyAdapter.getInternalChildAdapter()) {
                childAdapter.adapterController.initiatorAdapterId = initiatorAdapterId;
                action.onAction(childAdapter);
            }
        }
    }

    private String resetInitiator() {
        try {
            String string = this.initiatorAdapterId;
            return string;
        }
        finally {
            this.initiatorAdapterId = "";
        }
    }

    private boolean isInitiatorEmpty() {
        return TextUtils.isEmpty((CharSequence)this.initiatorAdapterId);
    }

    private boolean isInitiator() {
        return ((NestableRvAdapter)((Object)this.attachedAdapter)).getAdapterId().equals(this.initiatorAdapterId);
    }

    private void updatePositionRange(int flag, boolean isInitiator, int positionStart, int itemCount) {
        switch (flag) {
            case 0: {
                if (isInitiator) {
                    if (!this.globalPositionRange.validity(positionStart)) break;
                    this.globalPositionRange.setLength(((RvAdapter)((Object)this.attachedAdapter)).getItemSize());
                    this.localPositionRange.setLength(((RvAdapter)((Object)this.attachedAdapter)).getItemSize());
                    break;
                }
                if (positionStart > this.globalPositionRange.getStartPosition()) break;
                this.globalPositionRange.startPositionIncrement(itemCount);
                this.globalPositionRange.setLength(((RvAdapter)((Object)this.attachedAdapter)).getItemSize());
                this.localPositionRange.setLength(((RvAdapter)((Object)this.attachedAdapter)).getItemSize());
                break;
            }
            case 1: {
                if (isInitiator) {
                    if (!this.globalPositionRange.contains(positionStart)) break;
                    this.globalPositionRange.setLength(((RvAdapter)((Object)this.attachedAdapter)).getItemSize());
                    this.localPositionRange.setLength(((RvAdapter)((Object)this.attachedAdapter)).getItemSize());
                    break;
                }
                if (positionStart > this.globalPositionRange.getStartPosition()) break;
                this.globalPositionRange.startPositionDecrement(itemCount);
                this.globalPositionRange.setLength(((RvAdapter)((Object)this.attachedAdapter)).getItemSize());
                this.localPositionRange.setLength(((RvAdapter)((Object)this.attachedAdapter)).getItemSize());
            }
        }
    }

    private PositionRange getGlobalPositionRange(NestableRvAdapter<?, RvHolder<?>> adapter, int startPosition) {
        if (adapter == this.attachedAdapter) {
            return new PositionRange(startPosition, ((RvAdapter)((Object)this.attachedAdapter)).getItemSize());
        }
        startPosition += adapter.getItemSize();
        for (NestableRvAdapter<?, RvHolder<?>> childAdapter : adapter.getInternalChildAdapter()) {
            if (childAdapter == this.attachedAdapter || childAdapter.containsChildrenAdapter((NestableRvAdapter<?, RvHolder<?>>)((Object)this.attachedAdapter))) {
                return this.getGlobalPositionRange(childAdapter, startPosition);
            }
            startPosition += childAdapter.getItemCount();
        }
        throw new IllegalStateException("getGlobalPositionRange() adapter is not a valid state");
    }

    void rememberItemType(int itemType) {
        this.itemTypeStore.add(itemType);
    }

    boolean hasItemType(int itemType) {
        return this.itemTypeStore.contains(itemType);
    }

    public void notifyLocalDataSetChanged() {
        this.attachedAdapter.notifyItemRangeChanged(this.globalPositionRange.getStartPosition(), this.globalPositionRange.getEndPosition());
    }

    public boolean isGlobalRangeContainsGlobalPosition(int globalPosition) {
        return this.globalPositionRange.contains(globalPosition);
    }

    public boolean isLocalRangeContainsGlobalPosition(int globalPosition) {
        int convertLocalPosition = this.convertLocalPosition(globalPosition);
        return this.localPositionRange.contains(convertLocalPosition);
    }

    public int convertLocalPosition(int globalPosition) {
        return globalPosition - this.globalPositionRange.getStartPosition();
    }

    public int convertGlobalPosition(int localPosition) {
        return this.globalPositionRange.getStartPosition() + localPosition;
    }

    public int getGlobalStartPosition() {
        return this.globalPositionRange.getStartPosition();
    }

    public int getGlobalEndPosition() {
        return this.globalPositionRange.getEndPosition();
    }

    public void registerLocalAdapterDataObserver(@NonNull RecyclerView.AdapterDataObserver observer) {
        if (!this.localAdapterDataObservers.contains(observer)) {
            this.localAdapterDataObservers.add(observer);
        }
    }

    public void unregisterLocalAdapterDataObserver(@NonNull RecyclerView.AdapterDataObserver observer) {
        this.localAdapterDataObservers.remove(observer);
    }

    public static interface OnNotifyChangeAction {
        public void onAction(NestableRvAdapter<?, RvHolder<?>> var1);
    }
}

