/*
 * Decompiled with CFR 0.152.
 */
package com.passerby.recyclerviewlib.recycler.adapter;

import android.content.Context;
import android.view.ViewGroup;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.passerby.recyclerviewlib.recycler.adapter.NestableAdapterAction;
import com.passerby.recyclerviewlib.recycler.adapter.NestableAdapterController;
import com.passerby.recyclerviewlib.recycler.adapter.RvAdapter;
import com.passerby.recyclerviewlib.recycler.adapter.RvHolder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public abstract class NestableRvAdapter<Item, Holder extends RvHolder<Item>>
extends RvAdapter<Item, Holder> {
    private final String ADAPTER_ID;
    NestableAdapterController<NestableRvAdapter<?, RvHolder<?>>> adapterController;
    private WeakReference<NestableRvAdapter<?, RvHolder<?>>> parentAdapterReference;
    private final List<NestableRvAdapter<?, RvHolder<?>>> childrenAdapter = new ArrayList();

    public NestableRvAdapter(@NonNull Context context) {
        this(context, UUID.randomUUID().toString());
    }

    public NestableRvAdapter(@NonNull Context context, @NonNull String adapterId) {
        super(context);
        this.ADAPTER_ID = adapterId;
        this.adapterController = new NestableAdapterController<NestableRvAdapter>(this);
    }

    @CallSuper
    protected void attachedParentAdapter(NestableRvAdapter<?, RvHolder<?>> parentAdapter) {
        this.parentAdapterReference = new WeakReference(parentAdapter);
        this.teamAction(this.getRootAdapter(), adapter -> {
            adapter.adapterController.suspend();
            adapter.adapterController.reboot();
        });
    }

    @CallSuper
    protected void detachParentAdapter(NestableRvAdapter<?, RvHolder<?>> parentAdapter) {
        if (this.parentAdapterReference != null) {
            this.parentAdapterReference.clear();
            this.parentAdapterReference = null;
        }
        this.teamAction(this.getRootAdapter(), adapter -> {
            adapter.adapterController.suspend();
            adapter.adapterController.dispose();
        });
    }

    public void setHasStableIds(boolean hasStableIds) {
        NestableRvAdapter<?, RvHolder<?>> parent = this.getRootAdapter();
        if (parent != null) {
            parent.setHasStableIds(hasStableIds);
        } else {
            super.setHasStableIds(hasStableIds);
        }
    }

    public void setStateRestorationPolicy(@NonNull RecyclerView.Adapter.StateRestorationPolicy strategy) {
        NestableRvAdapter<?, RvHolder<?>> parent = this.getRootAdapter();
        if (parent != null) {
            parent.setStateRestorationPolicy(strategy);
        } else {
            super.setStateRestorationPolicy(strategy);
        }
    }

    @Override
    @NonNull
    public final Holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return (Holder)((Object)this.dispatchCreateHolder(this.getRootAdapter(), parent, viewType));
    }

    @Nullable
    private RvHolder<?> dispatchCreateHolder(NestableRvAdapter<?, RvHolder<?>> adapter, @NonNull ViewGroup parent, int viewType) {
        if (adapter.adapterController.hasItemType(viewType)) {
            return super.onCreateViewHolder(parent, viewType);
        }
        for (NestableRvAdapter<?, RvHolder<?>> childAdapter : adapter.getInternalChildAdapter()) {
            RvHolder<?> rvHolder = childAdapter.dispatchCreateHolder(childAdapter, parent, viewType);
            if (rvHolder == null) continue;
            return rvHolder;
        }
        if (this.getParentAdapter() != null) {
            return null;
        }
        throw new IllegalArgumentException("dispatchCreateHolder(), No Adapter that can generate Holder was found, type = " + viewType);
    }

    @Override
    public final void onBindViewHolder(@NonNull Holder holder, int position) {
        if (this.adapterController.isGlobalRangeContainsGlobalPosition(position)) {
            super.onBindViewHolder(holder, this.convertLocalPosition(position));
            return;
        }
        this.dispatchBindHolder(this, (RvHolder<?>)((Object)holder), position);
    }

    @Override
    public final void onBindViewHolder(@NonNull Holder holder, int position, @NonNull List<Object> payloads) {
        if (this.adapterController.isGlobalRangeContainsGlobalPosition(position)) {
            super.onBindViewHolder(holder, this.convertLocalPosition(position), payloads);
            return;
        }
        this.dispatchBindHolder(this, (RvHolder<?>)((Object)holder), position);
    }

    private void dispatchBindHolder(NestableRvAdapter<?, RvHolder<?>> adapter, @NonNull RvHolder<?> holder, int position) {
        for (NestableRvAdapter<?, RvHolder<?>> childAdapter : adapter.childrenAdapter) {
            childAdapter.bindViewHolder(holder, position);
        }
    }

    public final int getItemViewType(int position) {
        if (this.adapterController.isGlobalRangeContainsGlobalPosition(position)) {
            int type = this.getLocalItemViewType(this.convertLocalPosition(position));
            if (type > 0) {
                this.adapterController.rememberItemType(type);
            }
            return type;
        }
        if (!this.childrenAdapter.isEmpty()) {
            for (NestableRvAdapter<?, RvHolder<?>> childAdapter : this.childrenAdapter) {
                int type = childAdapter.getItemViewType(position);
                if (type <= 0) continue;
                return type;
            }
        }
        if (this.getParentAdapter() != null) {
            return 0;
        }
        throw new IllegalArgumentException("getItemViewType() Could not get the correct type. position = " + position);
    }

    public abstract int getLocalItemViewType(int var1);

    public final long getItemId(int position) {
        if (this.adapterController.isGlobalRangeContainsGlobalPosition(position)) {
            return this.getLocalItemId(this.convertLocalPosition(position));
        }
        if (!this.childrenAdapter.isEmpty()) {
            for (NestableRvAdapter<?, RvHolder<?>> childAdapter : this.childrenAdapter) {
                long itemId = childAdapter.getLocalItemId(position);
                if (itemId == -1L) continue;
                return itemId;
            }
        }
        return super.getItemId(position);
    }

    public long getLocalItemId(int position) {
        return super.getItemId(position);
    }

    @Override
    public final int getItemCount() {
        int totalItemCount = this.getItemSize();
        for (NestableRvAdapter<?, RvHolder<?>> childAdapter : this.childrenAdapter) {
            totalItemCount += childAdapter.getItemCount();
        }
        return totalItemCount;
    }

    public int getLocalItemCount() {
        return this.getItemSize();
    }

    public final int findRelativeAdapterPositionIn(@NonNull RecyclerView.Adapter<? extends RecyclerView.ViewHolder> adapter, @NonNull RecyclerView.ViewHolder viewHolder, int globalPosition) {
        if (this.adapterController.isGlobalRangeContainsGlobalPosition(globalPosition)) {
            return this.convertLocalPosition(globalPosition);
        }
        return -1;
    }

    public void onViewRecycled(@NonNull Holder holder) {
        if (holder.getBindingAdapter() == this) {
            this.onLocalViewRecycled(holder);
        }
        super.onViewRecycled(holder);
    }

    public void onLocalViewRecycled(@NonNull Holder holder) {
    }

    public boolean onFailedToRecycleView(@NonNull Holder holder) {
        if (holder.getBindingAdapter() == this) {
            return this.onLocalFailedToRecycleView(holder);
        }
        return super.onFailedToRecycleView(holder);
    }

    public boolean onLocalFailedToRecycleView(@NonNull Holder holder) {
        return super.onFailedToRecycleView(holder);
    }

    public void onViewAttachedToWindow(@NonNull Holder holder) {
        if (holder.getBindingAdapter() == this) {
            this.onLocalViewAttachedToWindow(holder);
        }
        super.onViewAttachedToWindow(holder);
    }

    public void onLocalViewAttachedToWindow(@NonNull Holder holder) {
    }

    public void onViewDetachedFromWindow(@NonNull Holder holder) {
        if (holder.getBindingAdapter() == this) {
            this.onLocalViewDetachedFromWindow(holder);
        }
        super.onViewDetachedFromWindow(holder);
    }

    public void onLocalViewDetachedFromWindow(@NonNull Holder holder) {
    }

    public void registerLocalAdapterDataObserver(@NonNull RecyclerView.AdapterDataObserver observer) {
        this.adapterController.registerLocalAdapterDataObserver(observer);
    }

    public void unregisterLocalAdapterDataObserver(@NonNull RecyclerView.AdapterDataObserver observer) {
        this.adapterController.unregisterLocalAdapterDataObserver(observer);
    }

    @Override
    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        for (NestableRvAdapter<?, RvHolder<?>> childAdapter : this.childrenAdapter) {
            childAdapter.onAttachedToRecyclerView(recyclerView);
        }
    }

    @Override
    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        for (NestableRvAdapter<?, RvHolder<?>> childAdapter : this.childrenAdapter) {
            childAdapter.onDetachedFromRecyclerView(recyclerView);
        }
    }

    public void notifyLocalDataSetChanged() {
        this.adapterController.notifyLocalDataSetChanged();
    }

    void teamAction(NestableRvAdapter<?, ? extends RvHolder<?>> rootAdapter, NestableAdapterAction action) {
        if (rootAdapter == null) {
            rootAdapter = this.getRootAdapter();
        }
        action.onAction(rootAdapter);
        for (NestableRvAdapter<?, RvHolder<?>> childAdapter : rootAdapter.childrenAdapter) {
            childAdapter.teamAction(childAdapter, action);
        }
    }

    @Override
    public void clearItems() {
        this.store.clear();
        this.notifyLocalDataSetChanged();
    }

    public <Adapter extends NestableRvAdapter<?, ? extends RvHolder<?>>> NestableRvAdapter<Item, Holder> addAdapter(@NonNull Adapter child) {
        return this.addAdapter(this.childrenAdapter.size(), child);
    }

    public <Adapter extends NestableRvAdapter<?, ? extends RvHolder<?>>> NestableRvAdapter<Item, Holder> addAdapter(int index, @NonNull Adapter child) {
        if (index < 0 || index > this.childrenAdapter.size()) {
            throw new IndexOutOfBoundsException("Index must be between 0 and " + this.childrenAdapter.size() + ". Given:" + index);
        }
        if (child.getParentAdapter() != null) {
            throw new IllegalStateException("child is already attached parent");
        }
        if (!this.childrenAdapter.contains(child)) {
            this.childrenAdapter.add(index, child);
            child.attachedParentAdapter(this);
            if (this.getRecyclerView() != null) {
                child.onAttachedToRecyclerView(this.getRecyclerView());
            }
            int notifyStartPosition = child.adapterController.getGlobalStartPosition();
            this.notifyItemRangeInserted(this.convertLocalPosition(notifyStartPosition), child.getItemCount());
        }
        return this;
    }

    public <Adapter extends NestableRvAdapter<?, ? extends RvHolder<?>>> void setAdapter(int index, @NonNull Adapter child) {
        if (index < 0 || index > this.childrenAdapter.size()) {
            throw new IndexOutOfBoundsException("Index must be between 0 and " + this.childrenAdapter.size() + ". Given:" + index);
        }
        if (child.getParentAdapter() != null) {
            throw new IllegalStateException("child is already attached parent");
        }
        if (index < this.childrenAdapter.size() && !this.childrenAdapter.contains(child)) {
            this.childrenAdapter.set(index, child);
            child.attachedParentAdapter(this);
            if (this.getRecyclerView() != null) {
                child.onAttachedToRecyclerView(this.getRecyclerView());
            }
            int notifyStartPosition = child.adapterController.getGlobalStartPosition();
            this.notifyItemRangeChanged(this.convertLocalPosition(notifyStartPosition), child.getItemCount());
        }
    }

    public boolean removeAdapter(@NonNull NestableRvAdapter<?, ? extends RvHolder<?>> child, boolean fromRoot) {
        NestableRvAdapter<?, RvHolder<?>> rootAdapter;
        NestableRvAdapter<?, RvHolder<?>> nestableRvAdapter = rootAdapter = fromRoot ? this.getRootAdapter() : this;
        if (rootAdapter.childrenAdapter.remove(child)) {
            int notifyStartPosition = child.adapterController.getGlobalStartPosition();
            child.detachParentAdapter(this);
            if (this.getRecyclerView() != null) {
                child.onDetachedFromRecyclerView(this.getRecyclerView());
            }
            this.notifyItemRangeRemoved(this.convertLocalPosition(notifyStartPosition), child.getItemCount());
            return true;
        }
        for (NestableRvAdapter<?, RvHolder<?>> childAdapter : rootAdapter.childrenAdapter) {
            if (!childAdapter.removeAdapter(child, false)) continue;
            return true;
        }
        return false;
    }

    public boolean removeAdapter(@NonNull String adapterId, boolean fromRoot) {
        if (this.getAdapterId().equals(adapterId)) {
            if (this.getParentAdapter() != null) {
                return this.getParentAdapter().removeAdapter(this, false);
            }
            return true;
        }
        for (NestableRvAdapter<?, RvHolder<?>> childAdapter : (fromRoot ? this.getRootAdapter() : this).childrenAdapter) {
            if (!childAdapter.removeAdapter(adapterId, false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public NestableRvAdapter<?, RvHolder<?>> findChildAdapter(String adapterId, boolean fromRoot) {
        if (this.getAdapterId().equals(adapterId)) {
            return this;
        }
        for (NestableRvAdapter<?, RvHolder<?>> childAdapter : (fromRoot ? this.getRootAdapter() : this).childrenAdapter) {
            NestableRvAdapter<?, RvHolder<?>> result = childAdapter.findChildAdapter(adapterId, false);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public NestableRvAdapter<?, RvHolder<?>> getParentAdapter() {
        return this.parentAdapterReference == null ? null : (NestableRvAdapter)((Object)this.parentAdapterReference.get());
    }

    public NestableRvAdapter<?, RvHolder<?>> getRootAdapter() {
        NestableRvAdapter<?, RvHolder<?>> parentAdapter;
        if (this.getRecyclerView() != null && this.getRecyclerView().getAdapter() instanceof NestableRvAdapter) {
            return (NestableRvAdapter)this.getRecyclerView().getAdapter();
        }
        for (parentAdapter = this.getParentAdapter(); parentAdapter != null && parentAdapter.getParentAdapter() != null; parentAdapter = parentAdapter.getParentAdapter()) {
        }
        return parentAdapter != null ? parentAdapter : this;
    }

    public List<NestableRvAdapter<?, RvHolder<?>>> getChildrenAdapter() {
        return new ArrayList(this.childrenAdapter);
    }

    List<NestableRvAdapter<?, RvHolder<?>>> getInternalChildAdapter() {
        return this.childrenAdapter;
    }

    public int getChildrenAdapterCount() {
        return this.childrenAdapter.size();
    }

    public int getAllChildrenAdapterCount() {
        if (this.childrenAdapter.isEmpty()) {
            return this.getChildrenAdapterCount();
        }
        int allCount = 0;
        for (NestableRvAdapter<?, RvHolder<?>> adapter : this.childrenAdapter) {
            allCount += adapter.getAllChildrenAdapterCount();
        }
        return allCount;
    }

    public final String getAdapterId() {
        return this.ADAPTER_ID;
    }

    public boolean containsChildrenAdapter(NestableRvAdapter<?, RvHolder<?>> adapter) {
        for (NestableRvAdapter<?, RvHolder<?>> childAdapter : this.childrenAdapter) {
            if (!childAdapter.containsChildrenAdapter(adapter)) continue;
            return true;
        }
        return this.childrenAdapter.contains(adapter);
    }

    public int convertGlobalPosition(int localPosition) {
        return this.adapterController.convertGlobalPosition(localPosition);
    }

    public int convertLocalPosition(int globalPosition) {
        return this.adapterController.convertLocalPosition(globalPosition);
    }

    public int getGlobalStartPosition() {
        return this.adapterController.getGlobalStartPosition();
    }

    public int getGlobalEndPosition() {
        return this.adapterController.getGlobalEndPosition();
    }
}

