/*
 * Decompiled with CFR 0.152.
 */
package com.passerby.recyclerviewlib.recycler.adapter;

class PositionRange {
    private int startPosition;
    private int length;

    public PositionRange(int startPosition, int length) {
        this.startPosition = startPosition;
        this.length = length;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public int getEndPosition() {
        return this.startPosition + Math.max(this.length - 1, 0);
    }

    public void startPositionIncrement(int value) {
        this.startPosition += value;
    }

    public void startPositionDecrement(int value) {
        this.startPosition -= value;
    }

    public void lengthIncrement(int value) {
        this.length += value;
    }

    public void lengthDecrement(int value) {
        this.length -= value;
    }

    public boolean validity(int valuePosition) {
        return valuePosition >= this.startPosition && valuePosition <= this.startPosition + this.length;
    }

    public boolean contains(int valuePosition) {
        return valuePosition >= this.startPosition && valuePosition <= this.getEndPosition();
    }

    public boolean isEmpty() {
        return this.startPosition == 0 && this.getEndPosition() == 0;
    }

    public void copy(PositionRange destRange) {
        destRange.setStartPosition(this.startPosition);
        destRange.setLength(this.length);
    }
}

