/*
 * Decompiled with CFR 0.152.
 */
package com.passerby.recyclerviewlib.recycler.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.CallSuper;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.passerby.recyclerviewlib.recycler.adapter.OnItemClickListener;
import com.passerby.recyclerviewlib.recycler.adapter.OnItemLongClickListener;
import com.passerby.recyclerviewlib.recycler.adapter.RvHolder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class RvAdapter<Item, Holder extends RvHolder<Item>>
extends RecyclerView.Adapter<Holder> {
    protected final Context context;
    final List<Item> store = new ArrayList<Item>();
    private final LayoutInflater layoutInflater;
    private WeakReference<RecyclerView> recyclerViewReference;
    private List<OnItemClickListener<Holder, Item>> onItemClickListeners;
    private List<OnItemLongClickListener<Holder, Item>> onItemLongClickListeners;

    public RvAdapter(@NonNull Context context) {
        this.context = context;
        this.layoutInflater = LayoutInflater.from((Context)context);
    }

    protected abstract int getLayoutId(int var1);

    protected abstract Holder createHolder(@NonNull Context var1, @NonNull View var2, int var3);

    @NonNull
    public Holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return this.internalCreateHolder(parent, viewType);
    }

    public void onBindViewHolder(@NonNull Holder holder, int position) {
        this.onBindHolder(holder, position, null);
    }

    public void onBindViewHolder(@NonNull Holder holder, int position, @NonNull List<Object> payloads) {
        this.onBindHolder(holder, position, payloads);
    }

    protected void onBindHolder(@NonNull Holder holder, int position, List<Object> payloads) {
        Item item = this.getItem(position);
        ((RvHolder)((Object)holder)).onBind(item, position);
        if (payloads == null || payloads.isEmpty()) {
            ((RvHolder)((Object)holder)).onUpdate(item, position);
            this.onUpdate(holder, item, position);
        } else {
            ((RvHolder)((Object)holder)).onUpdate(item, position, payloads);
            this.onUpdate(holder, item, position, payloads);
        }
    }

    protected void onUpdate(@NonNull Holder holder, @NonNull Item item, int position) {
    }

    protected void onUpdate(@NonNull Holder holder, @NonNull Item item, int position, List<Object> payloads) {
    }

    private Holder internalCreateHolder(@NonNull ViewGroup parent, int viewType) {
        int layoutId = this.getLayoutId(viewType);
        View itemView = this.layoutInflater.inflate(layoutId, parent, false);
        Holder holder = this.createHolder(this.context, itemView, viewType);
        itemView.setOnClickListener(v -> this.internalOnItemClick(holder));
        itemView.setOnLongClickListener(v -> this.internalOnItemLongClick(holder));
        return holder;
    }

    public int getItemCount() {
        return this.store.size();
    }

    protected int getSpanSize(int itemType) {
        return 1;
    }

    protected void internalOnItemClick(Holder holder) {
        ((RvHolder)((Object)holder)).onItemClick(((RvHolder)((Object)holder)).item(), ((RvHolder)((Object)holder)).position());
        this.onItemClick(holder, ((RvHolder)((Object)holder)).item(), ((RvHolder)((Object)holder)).position());
        if (this.onItemClickListeners != null) {
            for (OnItemClickListener listener : this.onItemClickListeners) {
                listener.onItemClick(holder, ((RvHolder)((Object)holder)).item(), ((RvHolder)((Object)holder)).position());
            }
        }
    }

    protected void onItemClick(Holder holder, Item item, int position) {
    }

    private boolean internalOnItemLongClick(Holder holder) {
        boolean result = false;
        result |= ((RvHolder)((Object)holder)).onItemLongClick(((RvHolder)((Object)holder)).item(), ((RvHolder)((Object)holder)).position());
        result |= this.onItemLongClick(holder, ((RvHolder)((Object)holder)).item(), ((RvHolder)((Object)holder)).position());
        if (this.onItemLongClickListeners != null) {
            for (OnItemLongClickListener listener : this.onItemLongClickListeners) {
                result |= listener.onItemLongClick(holder, ((RvHolder)((Object)holder)).item(), ((RvHolder)((Object)holder)).position());
            }
        }
        return result;
    }

    private boolean onItemLongClick(Holder holder, Item item, int position) {
        return false;
    }

    @CallSuper
    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        this.recyclerViewReference = new WeakReference<RecyclerView>(recyclerView);
    }

    @CallSuper
    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        if (this.recyclerViewReference != null) {
            this.recyclerViewReference.clear();
            this.recyclerViewReference = null;
        }
    }

    protected RecyclerView getRecyclerView() {
        return this.recyclerViewReference != null ? (RecyclerView)this.recyclerViewReference.get() : null;
    }

    protected int getColor(@ColorRes int colorRes) {
        return ContextCompat.getColor((Context)this.context, (int)colorRes);
    }

    protected String getString(@StringRes int stringRes) {
        return this.context.getString(stringRes);
    }

    protected Drawable getDrawable(@DrawableRes int drawableRes) {
        return ContextCompat.getDrawable((Context)this.context, (int)drawableRes);
    }

    public Item setItem(int index, Item item) {
        Item old = this.store.set(index, item);
        this.notifyItemChanged(index);
        return old;
    }

    public List<Item> setItems(int startIndex, List<Item> items) {
        ArrayList<Item> olds = new ArrayList<Item>();
        for (int i = 0; i < items.size(); ++i) {
            olds.add(this.store.set(startIndex + i, items.get(i)));
        }
        this.notifyItemRangeChanged(startIndex, items.size());
        return olds;
    }

    public void addItem(Item item) {
        this.store.add(item);
        this.notifyItemInserted(this.store.size() - 1);
    }

    public void addItem(int index, Item item) {
        this.store.add(index, item);
        this.notifyItemInserted(index);
    }

    public void addItems(List<Item> items) {
        int size = this.store.size();
        this.store.addAll(items);
        this.notifyItemRangeInserted(size, items.size());
    }

    public void addItems(int index, List<Item> items) {
        this.store.addAll(index, items);
        this.notifyItemRangeInserted(index, items.size());
    }

    public Item removeItem(int index) {
        if (index > this.store.size() || index < 0) {
            return null;
        }
        Item item = this.store.remove(index);
        this.notifyItemRemoved(index);
        return item;
    }

    public Item removeItem(Item item) {
        int removeIndex = -1;
        for (int i = 0; i < this.store.size(); ++i) {
            if (item != this.store.get(i)) continue;
            removeIndex = i;
            break;
        }
        if (removeIndex != -1) {
            this.store.remove(removeIndex);
            this.notifyItemRemoved(removeIndex);
            return item;
        }
        return null;
    }

    public List<Item> removeItems(List<Item> items) {
        ArrayList<Item> removed = new ArrayList<Item>();
        for (Item item : items) {
            Item removeItem = this.removeItem(item);
            if (removeItem == null) continue;
            removed.add(removeItem);
        }
        return removed;
    }

    public void clearItems() {
        this.store.clear();
        this.notifyDataSetChanged();
    }

    public void clearAndAddItems(List<Item> items) {
        this.clearItems();
        this.addItems(items);
    }

    public Item getItem(int position) {
        if (position < this.store.size() && position >= 0) {
            return this.store.get(position);
        }
        return null;
    }

    public int getItemPosition(Item item) {
        return this.store.indexOf(item);
    }

    public List<Item> getItems() {
        return new ArrayList<Item>(this.store);
    }

    public int getItemSize() {
        return this.store.size();
    }

    public void addOnItemClickListener(OnItemClickListener<Holder, Item> listener) {
        if (this.onItemClickListeners == null) {
            this.onItemClickListeners = new ArrayList<OnItemClickListener<Holder, Item>>();
        }
        if (this.onItemClickListeners.contains(listener)) {
            return;
        }
        this.onItemClickListeners.add(listener);
    }

    public void removeOnItemClickListener(OnItemClickListener<Holder, Item> listener) {
        if (this.onItemClickListeners != null) {
            this.onItemClickListeners.remove(listener);
        }
    }

    public void addOnItemLongClickListener(OnItemLongClickListener<Holder, Item> listener) {
        if (this.onItemLongClickListeners == null) {
            this.onItemLongClickListeners = new ArrayList<OnItemLongClickListener<Holder, Item>>();
        }
        if (this.onItemLongClickListeners.contains(listener)) {
            return;
        }
        this.onItemLongClickListeners.add(listener);
    }

    public void removeOnItemLongClickListener(OnItemLongClickListener<Holder, Item> listener) {
        if (this.onItemLongClickListeners != null) {
            this.onItemLongClickListeners.remove(listener);
        }
    }
}

