/*
 * Decompiled with CFR 0.152.
 */
package com.passerby.recyclerviewlib.recycler.decoration;

import android.graphics.Paint;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.passerby.recyclerviewlib.recycler.decoration.Direction;
import com.passerby.recyclerviewlib.recycler.decoration.DividerColor;
import com.passerby.recyclerviewlib.recycler.decoration.DividerDrawable;
import com.passerby.recyclerviewlib.recycler.decoration.DividerStyle;
import com.passerby.recyclerviewlib.recycler.decoration.Gravity;
import com.passerby.recyclerviewlib.recycler.decoration.OnCustomDrawDividerCallback;
import com.passerby.recyclerviewlib.recycler.decoration.OnGetHeaderOrFooterCountCallback;

public abstract class AbsItemDecoration
extends RecyclerView.ItemDecoration {
    protected static final int VERTICAL = 1;
    protected static final int HORIZONTAL = 0;
    protected int spacingWidth;
    protected int spacingHeight;
    protected DividerColor dividerColor;
    protected DividerDrawable dividerDrawable;
    protected Rect mViewBounds = new Rect();
    protected Rect dividerRect = new Rect();
    protected Paint dividerPaint = new Paint();
    protected Paint backupPaint = new Paint();
    protected OnGetHeaderOrFooterCountCallback onGetCountCallback;
    protected OnCustomDrawDividerCallback onCustomDrawDividerCallback;

    public AbsItemDecoration() {
        this(0, 0);
    }

    public AbsItemDecoration(int spacingWidth, int spacingHeight) {
        this.spacingWidth = spacingWidth;
        this.spacingHeight = spacingHeight;
        this.dividerPaint.setAntiAlias(true);
        this.backupPaint.setAntiAlias(true);
    }

    protected int getSpanIndex(RecyclerView.ViewHolder holder) {
        ViewGroup.LayoutParams layoutParams = holder.itemView.getLayoutParams();
        if (layoutParams instanceof StaggeredGridLayoutManager.LayoutParams) {
            return ((StaggeredGridLayoutManager.LayoutParams)layoutParams).getSpanIndex();
        }
        if (layoutParams instanceof GridLayoutManager.LayoutParams) {
            return ((GridLayoutManager.LayoutParams)layoutParams).getSpanIndex();
        }
        if (layoutParams instanceof RecyclerView.LayoutParams) {
            return 0;
        }
        return 0;
    }

    protected boolean isLTR(RecyclerView.LayoutManager layoutManager) {
        return layoutManager.getLayoutDirection() == 0;
    }

    protected boolean isReverse(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            return ((StaggeredGridLayoutManager)layoutManager).getReverseLayout();
        }
        if (layoutManager instanceof GridLayoutManager) {
            return ((GridLayoutManager)layoutManager).getReverseLayout();
        }
        if (layoutManager instanceof LinearLayoutManager) {
            return ((LinearLayoutManager)layoutManager).getReverseLayout();
        }
        return false;
    }

    protected boolean isVerticalOrientation(RecyclerView.LayoutManager layoutManager) {
        return this.getOrientation(layoutManager) == 1;
    }

    protected int getOrientation(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            return ((StaggeredGridLayoutManager)layoutManager).getOrientation();
        }
        if (layoutManager instanceof GridLayoutManager) {
            return ((GridLayoutManager)layoutManager).getOrientation();
        }
        if (layoutManager instanceof LinearLayoutManager) {
            return ((LinearLayoutManager)layoutManager).getOrientation();
        }
        return 1;
    }

    protected int getSpanCount(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            return ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
        }
        if (layoutManager instanceof GridLayoutManager) {
            return ((GridLayoutManager)layoutManager).getSpanCount();
        }
        if (layoutManager instanceof LinearLayoutManager) {
            return 1;
        }
        return 0;
    }

    protected Gravity getVerticalGravity(RecyclerView parent, RecyclerView.LayoutManager layoutManager, RecyclerView.ViewHolder holder, int position) {
        if (this.isSingle(layoutManager)) {
            return Gravity.Single;
        }
        if (this.isLastRow(parent, layoutManager, holder, position)) {
            return Gravity.End;
        }
        if (this.isFirstRow(parent, layoutManager, holder, position)) {
            return Gravity.Start;
        }
        return Gravity.Center;
    }

    protected Gravity getHorizontalGravity(RecyclerView parent, RecyclerView.LayoutManager layoutManager, RecyclerView.ViewHolder holder, int position) {
        if (this.isSingle(layoutManager)) {
            return Gravity.Single;
        }
        if (this.isLastColumn(parent, layoutManager, holder, position)) {
            return Gravity.End;
        }
        if (this.isFirstColumn(parent, layoutManager, holder, position)) {
            return Gravity.Start;
        }
        return Gravity.Center;
    }

    protected boolean isSingle(RecyclerView.LayoutManager layoutManager) {
        return layoutManager.getItemCount() == 1;
    }

    protected boolean isSingleRow(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            if (this.isVerticalOrientation(layoutManager)) {
                int spanCount;
                int itemCount = layoutManager.getItemCount();
                return itemCount <= (spanCount = this.getSpanCount(layoutManager));
            }
            return this.getSpanCount(layoutManager) == 1;
        }
        if (layoutManager instanceof GridLayoutManager) {
            if (this.isVerticalOrientation(layoutManager)) {
                int spanCount;
                int itemCount = layoutManager.getItemCount();
                return itemCount <= (spanCount = this.getSpanCount(layoutManager));
            }
            return this.getSpanCount(layoutManager) == 1;
        }
        if (layoutManager instanceof LinearLayoutManager) {
            return !this.isVerticalOrientation(layoutManager);
        }
        return false;
    }

    protected boolean isSingleColumn(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            int spanCount;
            if (this.isVerticalOrientation(layoutManager)) {
                return this.getSpanCount(layoutManager) == 1;
            }
            int itemCount = layoutManager.getItemCount();
            return itemCount <= (spanCount = this.getSpanCount(layoutManager));
        }
        if (layoutManager instanceof GridLayoutManager) {
            int spanCount;
            if (this.isVerticalOrientation(layoutManager)) {
                return this.getSpanCount(layoutManager) == 1;
            }
            int itemCount = layoutManager.getItemCount();
            return itemCount <= (spanCount = this.getSpanCount(layoutManager));
        }
        if (layoutManager instanceof LinearLayoutManager) {
            return this.isVerticalOrientation(layoutManager);
        }
        return false;
    }

    protected boolean isFirstRow(RecyclerView parent, RecyclerView.LayoutManager layoutManager, RecyclerView.ViewHolder holder, int position) {
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            if (this.isVerticalOrientation(layoutManager)) {
                return position < this.getSpanCount(layoutManager);
            }
            int spanIndex = ((StaggeredGridLayoutManager.LayoutParams)holder.itemView.getLayoutParams()).getSpanIndex();
            return spanIndex < 1;
        }
        if (layoutManager instanceof GridLayoutManager) {
            if (this.isVerticalOrientation(layoutManager)) {
                return position < this.getSpanCount(layoutManager);
            }
            int spanIndex = ((GridLayoutManager.LayoutParams)holder.itemView.getLayoutParams()).getSpanIndex();
            return spanIndex < 1;
        }
        if (layoutManager instanceof LinearLayoutManager) {
            if (this.isVerticalOrientation(layoutManager)) {
                return position < 1;
            }
            return true;
        }
        return false;
    }

    protected boolean isLastRow(RecyclerView parent, RecyclerView.LayoutManager layoutManager, RecyclerView.ViewHolder holder, int position) {
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            if (this.isVerticalOrientation(layoutManager)) {
                int surplus = layoutManager.getItemCount() % this.getSpanCount(layoutManager);
                return position + surplus >= layoutManager.getItemCount();
            }
            int spanIndex = ((StaggeredGridLayoutManager.LayoutParams)holder.itemView.getLayoutParams()).getSpanIndex();
            return spanIndex + 1 >= this.getSpanCount(layoutManager);
        }
        if (layoutManager instanceof GridLayoutManager) {
            if (this.isVerticalOrientation(layoutManager)) {
                int spanCount = this.getSpanCount(layoutManager);
                return position / spanCount == (layoutManager.getItemCount() - 1) / spanCount;
            }
            int spanIndex = ((GridLayoutManager.LayoutParams)holder.itemView.getLayoutParams()).getSpanIndex();
            return spanIndex + 1 >= this.getSpanCount(layoutManager);
        }
        if (layoutManager instanceof LinearLayoutManager) {
            if (this.isVerticalOrientation(layoutManager)) {
                return position + 1 >= layoutManager.getItemCount();
            }
            return true;
        }
        return false;
    }

    protected boolean isFirstColumn(RecyclerView parent, RecyclerView.LayoutManager layoutManager, RecyclerView.ViewHolder holder, int position) {
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            if (this.isVerticalOrientation(layoutManager)) {
                int spanIndex = ((StaggeredGridLayoutManager.LayoutParams)holder.itemView.getLayoutParams()).getSpanIndex();
                return spanIndex < 1;
            }
            return position < this.getSpanCount(layoutManager);
        }
        if (layoutManager instanceof GridLayoutManager) {
            if (this.isVerticalOrientation(layoutManager)) {
                int spanIndex = ((GridLayoutManager.LayoutParams)holder.itemView.getLayoutParams()).getSpanIndex();
                return spanIndex < 1;
            }
            return position < this.getSpanCount(layoutManager);
        }
        if (layoutManager instanceof LinearLayoutManager) {
            if (this.isVerticalOrientation(layoutManager)) {
                return true;
            }
            return position < 1;
        }
        return false;
    }

    protected boolean isLastColumn(RecyclerView parent, RecyclerView.LayoutManager layoutManager, RecyclerView.ViewHolder holder, int position) {
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            if (this.isVerticalOrientation(layoutManager)) {
                int spanIndex = ((StaggeredGridLayoutManager.LayoutParams)holder.itemView.getLayoutParams()).getSpanIndex();
                return spanIndex + 1 >= this.getSpanCount(layoutManager);
            }
            int surplus = layoutManager.getItemCount() % this.getSpanCount(layoutManager);
            return position + surplus >= layoutManager.getItemCount();
        }
        if (layoutManager instanceof GridLayoutManager) {
            if (this.isVerticalOrientation(layoutManager)) {
                int spanIndex = ((GridLayoutManager.LayoutParams)holder.itemView.getLayoutParams()).getSpanIndex();
                return spanIndex + 1 >= this.getSpanCount(layoutManager);
            }
            int spanCount = this.getSpanCount(layoutManager);
            return position / spanCount == (layoutManager.getItemCount() - 1) / spanCount;
        }
        if (layoutManager instanceof LinearLayoutManager) {
            if (this.isVerticalOrientation(layoutManager)) {
                return true;
            }
            return position + 1 >= layoutManager.getItemCount();
        }
        return false;
    }

    protected Rect measureDividerRect(RecyclerView parent, DividerStyle style, Rect dividerRect, Gravity verticalGravity, Gravity horizontalGravity, Direction direction, int left, int top, int right, int bottom) {
        dividerRect.set(left, top, right, bottom);
        return dividerRect;
    }

    protected void getViewBounds(View view, Rect outBounds) {
        outBounds.set(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
    }

    protected void minusBoundsWithMargins(View view, Rect outBounds) {
        RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)view.getLayoutParams();
        outBounds.set(outBounds.left - lp.leftMargin, outBounds.top - lp.topMargin, outBounds.right + lp.rightMargin, outBounds.bottom + lp.bottomMargin);
    }

    protected void minusBoundsWithTranslation(View view, Rect outBounds) {
        outBounds.set(outBounds.left + Math.round(view.getTranslationX()), outBounds.top + Math.round(view.getTranslationY()), outBounds.right + Math.round(view.getTranslationX()), outBounds.bottom + Math.round(view.getTranslationY()));
    }

    protected void rtlCompat(RecyclerView.LayoutManager layoutManager, Rect rect) {
        if (!this.isLTR(layoutManager)) {
            rect.left ^= rect.right;
            rect.right ^= rect.left;
            rect.left ^= rect.right;
        }
    }

    protected void reverseCompat(RecyclerView.LayoutManager layoutManager, Rect rect) {
        if (this.isReverse(layoutManager)) {
            if (this.isVerticalOrientation(layoutManager)) {
                rect.top ^= rect.bottom;
                rect.bottom ^= rect.top;
                rect.top ^= rect.bottom;
            } else {
                rect.left ^= rect.right;
                rect.right ^= rect.left;
                rect.left ^= rect.right;
            }
        }
    }

    protected DividerStyle getDivider() {
        if (this.dividerColor != null) {
            return this.dividerColor;
        }
        if (this.dividerDrawable != null) {
            return this.dividerDrawable;
        }
        return null;
    }

    public void setDividerColor(DividerColor dividerColor) {
        this.dividerColor = dividerColor;
        this.dividerDrawable = null;
        this.onCustomDrawDividerCallback = null;
    }

    public void setDividerDrawable(DividerDrawable dividerDrawable) {
        this.dividerDrawable = dividerDrawable;
        this.dividerColor = null;
        this.onCustomDrawDividerCallback = null;
    }

    public void setSpacingWidth(int spacingWidth) {
        this.spacingWidth = spacingWidth;
    }

    public void setSpacingHeight(int spacingHeight) {
        this.spacingHeight = spacingHeight;
    }

    public int getSpacingWidth() {
        return this.spacingWidth;
    }

    public int getSpacingHeight() {
        return this.spacingHeight;
    }

    public void setOnGetCountCallback(OnGetHeaderOrFooterCountCallback callback) {
        this.onGetCountCallback = callback;
    }

    public void setOnCustomDrawDividerCallback(OnCustomDrawDividerCallback callback) {
        this.onCustomDrawDividerCallback = callback;
        this.dividerColor = null;
        this.dividerDrawable = null;
    }
}

