/*
 * Decompiled with CFR 0.152.
 */
package com.passerby.recyclerviewlib.recycler.decoration;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.passerby.recyclerviewlib.recycler.decoration.AbsItemDecoration;
import com.passerby.recyclerviewlib.recycler.decoration.Direction;
import com.passerby.recyclerviewlib.recycler.decoration.DividerColor;
import com.passerby.recyclerviewlib.recycler.decoration.DividerDrawable;
import com.passerby.recyclerviewlib.recycler.decoration.Gravity;

public abstract class BaseItemDecoration
extends AbsItemDecoration {
    private boolean isShowVerticalBorder;
    private boolean isShowHorizontalBorder;

    public BaseItemDecoration() {
    }

    public BaseItemDecoration(int spacingWidth, int spacingHeight) {
        super(spacingWidth, spacingHeight);
    }

    public BaseItemDecoration(int spacingWidth, int spacingHeight, boolean isShowVerticalBorder, boolean isShowHorizontalBorder) {
        super(spacingWidth, spacingHeight);
        this.isShowVerticalBorder = isShowVerticalBorder;
        this.isShowHorizontalBorder = isShowHorizontalBorder;
    }

    public void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        super.onDraw(canvas, parent, state);
        this.onDrawDivider(canvas, parent);
    }

    protected void onDrawDivider(Canvas canvas, RecyclerView parent) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        canvas.save();
        canvas.clipRect(parent.getClipToPadding() ? parent.getPaddingLeft() : 0, parent.getClipToPadding() ? parent.getPaddingTop() : 0, parent.getWidth() - (parent.getClipToPadding() ? parent.getPaddingRight() : 0), parent.getHeight() - (parent.getClipToPadding() ? parent.getPaddingBottom() : 0));
        int spacingWidth = Math.max(this.spacingWidth, this.getDivider() != null ? this.getDivider().getVerticalWidth() : 0);
        int spacingHeight = Math.max(this.spacingHeight, this.getDivider() != null ? this.getDivider().getHorizontalHeight() : 0);
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View child = parent.getChildAt(i);
            this.getViewBounds(child, this.mViewBounds);
            this.minusBoundsWithMargins(child, this.mViewBounds);
            this.minusBoundsWithTranslation(child, this.mViewBounds);
            int left = this.mViewBounds.left + Math.round(child.getTranslationX());
            int right = this.mViewBounds.right + Math.round(child.getTranslationX());
            int top = this.mViewBounds.top + Math.round(child.getTranslationY());
            int bottom = this.mViewBounds.bottom + Math.round(child.getTranslationY());
            RecyclerView.ViewHolder holder = parent.getChildViewHolder(child);
            int position = holder.getAbsoluteAdapterPosition();
            Gravity verticalGravity = this.getVerticalGravity(parent, layoutManager, holder, position);
            Gravity horizontalGravity = this.getHorizontalGravity(parent, layoutManager, holder, position);
            this.drawViewLeft(parent, canvas, verticalGravity, horizontalGravity, left - spacingWidth, top - spacingHeight, left, bottom + spacingHeight);
            this.drawViewRight(parent, canvas, verticalGravity, horizontalGravity, right, top - spacingHeight, right + spacingWidth, bottom + spacingHeight);
            this.drawViewTop(parent, canvas, verticalGravity, horizontalGravity, left - spacingWidth, top - spacingHeight, right + spacingWidth, top);
            this.drawViewBottom(parent, canvas, verticalGravity, horizontalGravity, left - spacingWidth, bottom, right + spacingWidth, bottom + spacingHeight);
        }
        canvas.restore();
    }

    protected void drawViewLeft(RecyclerView parent, Canvas canvas, Gravity verticalGravity, Gravity horizontalGravity, int left, int top, int right, int bottom) {
    }

    protected void drawViewRight(RecyclerView parent, Canvas canvas, Gravity verticalGravity, Gravity horizontalGravity, int left, int top, int right, int bottom) {
    }

    protected void drawViewTop(RecyclerView parent, Canvas canvas, Gravity verticalGravity, Gravity horizontalGravity, int left, int top, int right, int bottom) {
    }

    protected void drawViewBottom(RecyclerView parent, Canvas canvas, Gravity verticalGravity, Gravity horizontalGravity, int left, int top, int right, int bottom) {
    }

    protected void drawDivider(RecyclerView parent, Canvas canvas, Gravity verticalGravity, Gravity horizontalGravity, Direction orientation, int left, int top, int right, int bottom) {
        if (this.dividerColor != null) {
            this.drawDividerColor(parent, this.dividerColor, canvas, verticalGravity, horizontalGravity, orientation, left, top, right, bottom);
        } else if (this.dividerDrawable != null) {
            this.drawDividerDrawable(parent, this.dividerDrawable, canvas, verticalGravity, horizontalGravity, orientation, left, top, right, bottom);
        } else {
            this.customDrawDivider(parent, canvas, verticalGravity, horizontalGravity, orientation, left, top, right, bottom);
        }
    }

    protected void drawDividerColor(RecyclerView parent, DividerColor dividerColor, Canvas canvas, Gravity verticalGravity, Gravity horizontalGravity, Direction orientation, int left, int top, int right, int bottom) {
        this.dividerRect.setEmpty();
        this.measureDividerRect(parent, dividerColor, this.dividerRect, verticalGravity, horizontalGravity, orientation, left, top, right, bottom);
        if (this.dividerRect.width() == 0 || this.dividerRect.height() == 0) {
            return;
        }
        this.dividerPaint.setColor(dividerColor.getColor());
        canvas.save();
        canvas.clipRect(this.dividerRect);
        canvas.drawRect(this.dividerRect, this.dividerPaint);
        canvas.restore();
    }

    protected void drawDividerDrawable(RecyclerView parent, DividerDrawable dividerDrawable, Canvas canvas, Gravity verticalGravity, Gravity horizontalGravity, Direction orientation, int left, int top, int right, int bottom) {
        this.dividerRect.setEmpty();
        this.measureDividerRect(parent, this.dividerColor, this.dividerRect, verticalGravity, horizontalGravity, orientation, left, top, right, bottom);
        if (this.dividerRect.width() == 0 || this.dividerRect.height() == 0) {
            return;
        }
        Drawable drawable = dividerDrawable.getDrawable();
        int save = canvas.save();
        canvas.clipRect(this.dividerRect);
        drawable.setBounds(this.dividerRect);
        drawable.draw(canvas);
        canvas.restoreToCount(save);
    }

    protected void customDrawDivider(RecyclerView parent, Canvas canvas, Gravity verticalGravity, Gravity horizontalGravity, Direction orientation, int left, int top, int right, int bottom) {
        this.dividerRect.setEmpty();
        if (this.onCustomDrawDividerCallback == null) {
            return;
        }
        this.measureDividerRect(parent, this.dividerColor, this.dividerRect, verticalGravity, horizontalGravity, orientation, left, top, right, bottom);
        if (this.dividerRect.width() == 0 || this.dividerRect.height() == 0) {
            return;
        }
        int save = canvas.save();
        canvas.clipRect(this.dividerRect);
        this.onCustomDrawDividerCallback.onDraw(canvas, this.backupPaint, this.dividerRect);
        canvas.restoreToCount(save);
    }

    public void setShowVerticalBorder(boolean isShow) {
        this.isShowVerticalBorder = isShow;
    }

    public void setShowHorizontalBorder(boolean isShow) {
        this.isShowHorizontalBorder = isShow;
    }

    public boolean isShowVerticalBorder() {
        return this.isShowVerticalBorder;
    }

    public boolean isShowHorizontalBorder() {
        return this.isShowHorizontalBorder;
    }
}

