/*
 * Decompiled with CFR 0.152.
 */
package com.passerby.recyclerviewlib.recycler.decoration;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.passerby.recyclerviewlib.recycler.decoration.BaseItemDecoration;
import com.passerby.recyclerviewlib.recycler.decoration.Direction;
import com.passerby.recyclerviewlib.recycler.decoration.DividerStyle;
import com.passerby.recyclerviewlib.recycler.decoration.Gravity;

public class GridItemDecoration
extends BaseItemDecoration {
    public GridItemDecoration() {
    }

    public GridItemDecoration(int spacingWidth, int spacingHeight) {
        super(spacingWidth, spacingHeight);
    }

    public GridItemDecoration(int spacingWidth, int spacingHeight, boolean isShowVerticalBorder, boolean isShowHorizontalBorder) {
        super(spacingWidth, spacingHeight, isShowVerticalBorder, isShowHorizontalBorder);
    }

    @Override
    public void onDraw(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager == null || this.dividerColor == null && this.dividerDrawable == null && this.onCustomDrawDividerCallback == null) {
            return;
        }
        if (layoutManager instanceof GridLayoutManager || layoutManager instanceof StaggeredGridLayoutManager) {
            this.onDrawDivider(c, parent);
        }
    }

    @Override
    protected void drawViewLeft(RecyclerView parent, Canvas canvas, Gravity verticalGravity, Gravity horizontalGravity, int left, int top, int right, int bottom) {
        if (!(horizontalGravity != Gravity.Start || this.isShowVerticalBorder() && this.getDivider().isDrawLeftBorderDivide())) {
            return;
        }
        if (this.spacingWidth == 0 && this.getDivider().getVerticalWidth() == 0) {
            return;
        }
        this.drawDivider(parent, canvas, verticalGravity, horizontalGravity, Direction.LEFT, left, top, right, bottom);
    }

    @Override
    protected void drawViewRight(RecyclerView parent, Canvas canvas, Gravity verticalGravity, Gravity horizontalGravity, int left, int top, int right, int bottom) {
        if (!(horizontalGravity != Gravity.End || this.isShowVerticalBorder() && this.getDivider().isDrawRightBorderDivide())) {
            return;
        }
        if (this.spacingWidth == 0 && this.getDivider().getVerticalWidth() == 0) {
            return;
        }
        this.drawDivider(parent, canvas, verticalGravity, horizontalGravity, Direction.RIGHT, left, top, right, bottom);
    }

    @Override
    protected void drawViewTop(RecyclerView parent, Canvas canvas, Gravity verticalGravity, Gravity horizontalGravity, int left, int top, int right, int bottom) {
        if (!(verticalGravity != Gravity.Start || this.isShowHorizontalBorder() && this.getDivider().isDrawTopBorderDivide())) {
            return;
        }
        if (this.spacingHeight == 0 && this.getDivider().getHorizontalHeight() == 0) {
            return;
        }
        this.drawDivider(parent, canvas, verticalGravity, horizontalGravity, Direction.TOP, left, top, right, bottom);
    }

    @Override
    protected void drawViewBottom(RecyclerView parent, Canvas canvas, Gravity verticalGravity, Gravity horizontalGravity, int left, int top, int right, int bottom) {
        if (!(verticalGravity != Gravity.End || this.isShowHorizontalBorder() && this.getDivider().isDrawBottomBorderDivide())) {
            return;
        }
        if (this.spacingHeight == 0 && this.getDivider().getHorizontalHeight() == 0) {
            return;
        }
        this.drawDivider(parent, canvas, verticalGravity, horizontalGravity, Direction.BOTTOM, left, top, right, bottom);
    }

    @Override
    protected Rect measureDividerRect(RecyclerView parent, DividerStyle style, Rect dividerRect, Gravity verticalGravity, Gravity horizontalGravity, Direction direction, int left, int top, int right, int bottom) {
        switch (direction) {
            case LEFT: 
            case RIGHT: {
                dividerRect.top = top;
                dividerRect.bottom = bottom;
                if (verticalGravity != Gravity.Single && horizontalGravity != Gravity.Single) {
                    if (right - left <= style.getVerticalWidth()) {
                        dividerRect.left = left;
                        dividerRect.right = left + style.getVerticalWidth();
                        if (this.spacingHeight > style.getHorizontalHeight()) {
                            dividerRect.top += this.spacingHeight / 2 - style.getHorizontalHeight() / 2;
                            dividerRect.bottom -= this.spacingHeight / 2 - style.getHorizontalHeight() / 2;
                        }
                    } else if (style.getGravity() == Gravity.Start) {
                        dividerRect.left = left;
                        dividerRect.right = left + style.getVerticalWidth();
                        dividerRect.bottom -= this.spacingHeight - style.getHorizontalHeight();
                    } else if (style.getGravity() == Gravity.Center) {
                        dividerRect.left = left + Math.round((float)(right - left - style.getVerticalWidth()) / 2.0f);
                        dividerRect.right = dividerRect.left + style.getVerticalWidth();
                        if (this.spacingHeight > style.getHorizontalHeight()) {
                            dividerRect.top += this.spacingHeight / 2 - style.getHorizontalHeight() / 2;
                            dividerRect.bottom -= this.spacingHeight / 2 - style.getHorizontalHeight() / 2;
                        }
                    } else if (style.getGravity() == Gravity.End) {
                        dividerRect.left = right - style.getVerticalWidth();
                        dividerRect.right = right;
                        dividerRect.top += this.spacingHeight;
                    }
                }
                if (verticalGravity == Gravity.Start) {
                    if (!this.isShowHorizontalBorder() || !this.getDivider().isDrawTopBorderDivide()) {
                        dividerRect.top = top;
                        dividerRect.top += Math.max(this.spacingHeight, style.getHorizontalHeight());
                    }
                    dividerRect.top += style.getVerticalTopPadding();
                }
                if (verticalGravity != Gravity.End) break;
                if (!this.isShowHorizontalBorder() || !this.getDivider().isDrawBottomBorderDivide()) {
                    dividerRect.bottom = bottom;
                    dividerRect.bottom -= Math.max(this.spacingHeight, style.getHorizontalHeight());
                }
                dividerRect.bottom -= style.getVerticalBottomPadding();
                break;
            }
            case TOP: 
            case BOTTOM: {
                dividerRect.left = left;
                dividerRect.right = right;
                if (verticalGravity != Gravity.Single && horizontalGravity != Gravity.Single) {
                    if (bottom - top <= style.getHorizontalHeight()) {
                        dividerRect.top = top;
                        dividerRect.bottom = top + style.getHorizontalHeight();
                        if (this.spacingWidth > style.getVerticalWidth()) {
                            dividerRect.left += this.spacingWidth / 2 - style.getVerticalWidth() / 2;
                            dividerRect.right -= this.spacingWidth / 2 - style.getVerticalWidth() / 2;
                        }
                    } else if (style.getGravity() == Gravity.Start) {
                        dividerRect.top = top;
                        dividerRect.bottom = top + style.getHorizontalHeight();
                        dividerRect.right -= this.spacingWidth - style.getVerticalWidth();
                    } else if (style.getGravity() == Gravity.Center) {
                        dividerRect.top = top + Math.round((float)(bottom - top - style.getHorizontalHeight()) / 2.0f);
                        dividerRect.bottom = dividerRect.top + style.getHorizontalHeight();
                        if (this.spacingWidth > style.getVerticalWidth()) {
                            dividerRect.left += this.spacingWidth / 2 - style.getVerticalWidth() / 2;
                            dividerRect.right -= this.spacingWidth / 2 - style.getVerticalWidth() / 2;
                        }
                    } else if (style.getGravity() == Gravity.End) {
                        dividerRect.top = bottom - style.getHorizontalHeight();
                        dividerRect.bottom = bottom;
                        dividerRect.left += this.spacingWidth;
                    }
                }
                if (horizontalGravity == Gravity.Start) {
                    if (!this.isShowVerticalBorder() || !this.getDivider().isDrawLeftBorderDivide()) {
                        dividerRect.left = left;
                        dividerRect.left += Math.max(this.spacingWidth, style.getVerticalWidth());
                    }
                    dividerRect.left += style.getHorizontalLeftPadding();
                }
                if (horizontalGravity != Gravity.End) break;
                if (!this.isShowVerticalBorder() || !this.getDivider().isDrawRightBorderDivide()) {
                    dividerRect.right = right;
                    dividerRect.right -= Math.max(this.spacingWidth, style.getVerticalWidth());
                }
                dividerRect.right -= style.getHorizontalRightPadding();
            }
        }
        this.rtlCompat(parent.getLayoutManager(), dividerRect);
        this.reverseCompat(parent.getLayoutManager(), dividerRect);
        return dividerRect;
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager == null) {
            super.getItemOffsets(outRect, view, parent, state);
            return;
        }
        if (layoutManager instanceof GridLayoutManager || layoutManager instanceof StaggeredGridLayoutManager) {
            this.measureItemOffsets(outRect, view, parent, layoutManager, state);
        } else {
            super.getItemOffsets(outRect, view, parent, state);
        }
    }

    protected void measureItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.LayoutManager layoutManager, RecyclerView.State state) {
        int bottom;
        int top;
        int right;
        int left;
        RecyclerView.ViewHolder holder = parent.getChildViewHolder(view);
        int position = holder.getAbsoluteAdapterPosition();
        int orientation = this.getOrientation(layoutManager);
        Gravity verticalGravity = this.getVerticalGravity(parent, layoutManager, holder, position);
        Gravity horizontalGravity = this.getHorizontalGravity(parent, layoutManager, holder, position);
        int spanCount = this.getSpanCount(layoutManager);
        int spanIndex = this.getSpanIndex(holder);
        int spacingWidth = Math.max(this.spacingWidth, this.getDivider() != null ? this.getDivider().getVerticalWidth() : 0);
        int spacingHeight = Math.max(this.spacingHeight, this.getDivider() != null ? this.getDivider().getHorizontalHeight() : 0);
        if (orientation == 1) {
            if (this.isShowVerticalBorder()) {
                left = (int)((float)(spanCount - spanIndex) / (float)spanCount * (float)spacingWidth);
                right = (int)((float)spacingWidth * (float)(spanCount + 1) / (float)spanCount - (float)left);
            } else {
                left = spanIndex * spacingWidth / spanCount;
                right = spacingWidth - (spanIndex + 1) * spacingWidth / spanCount;
            }
            top = spacingHeight;
            bottom = spacingHeight;
        } else {
            if (this.isShowHorizontalBorder()) {
                top = (int)((float)(spanCount - spanIndex) / (float)spanCount * (float)spacingHeight);
                bottom = (int)((float)spacingHeight * (float)(spanCount + 1) / (float)spanCount - (float)top);
            } else {
                top = spanIndex * spacingHeight / spanCount;
                bottom = spacingHeight - (spanIndex + 1) * spacingHeight / spanCount;
            }
            left = spacingWidth;
            right = spacingWidth;
        }
        if (this.isSingle(layoutManager)) {
            outRect.set(this.isShowVerticalBorder() ? left : 0, this.isShowHorizontalBorder() ? top : 0, this.isShowVerticalBorder() ? right : 0, this.isShowHorizontalBorder() ? bottom : 0);
        } else {
            block0 : switch (verticalGravity) {
                case Start: {
                    switch (horizontalGravity) {
                        case Start: {
                            outRect.set(this.isShowVerticalBorder() ? left : 0, this.isShowHorizontalBorder() ? top : 0, right, bottom);
                            break;
                        }
                        case Center: {
                            if (orientation == 1) {
                                outRect.set(left, this.isShowHorizontalBorder() ? top : 0, right, bottom);
                                break;
                            }
                            outRect.set(0, this.isShowHorizontalBorder() ? top : 0, right, bottom);
                            break;
                        }
                        case End: {
                            if (orientation == 1) {
                                outRect.set(left, this.isShowHorizontalBorder() ? top : 0, this.isShowVerticalBorder() ? right : 0, bottom);
                                break;
                            }
                            outRect.set(this.isSingleColumn(layoutManager) ? (this.isShowVerticalBorder() ? left : 0) : 0, top, this.isShowVerticalBorder() ? right : 0, bottom);
                        }
                    }
                    break;
                }
                case Center: {
                    switch (horizontalGravity) {
                        case Start: {
                            if (orientation == 1) {
                                outRect.set(this.isShowVerticalBorder() ? left : 0, 0, right, bottom);
                                break;
                            }
                            outRect.set(this.isShowVerticalBorder() ? left : 0, top, right, bottom);
                            break;
                        }
                        case Center: {
                            if (orientation == 1) {
                                outRect.set(left, 0, right, bottom);
                                break;
                            }
                            outRect.set(0, top, right, bottom);
                            break;
                        }
                        case End: {
                            if (orientation == 1) {
                                outRect.set(left, 0, this.isShowVerticalBorder() ? right : 0, bottom);
                                break;
                            }
                            outRect.set(this.isSingleColumn(layoutManager) ? (this.isShowVerticalBorder() ? left : 0) : 0, top, this.isShowHorizontalBorder() ? right : 0, bottom);
                        }
                    }
                    break;
                }
                case End: {
                    switch (horizontalGravity) {
                        case Start: {
                            if (orientation == 1) {
                                outRect.set(this.isShowVerticalBorder() ? left : 0, this.isSingleRow(layoutManager) ? (this.isShowHorizontalBorder() ? top : 0) : 0, right, this.isShowHorizontalBorder() ? bottom : 0);
                                break block0;
                            }
                            outRect.set(this.isShowVerticalBorder() ? left : 0, top, right, this.isShowHorizontalBorder() ? bottom : 0);
                            break block0;
                        }
                        case Center: {
                            if (orientation == 1) {
                                outRect.set(left, this.isSingleRow(layoutManager) ? (this.isShowHorizontalBorder() ? top : 0) : 0, right, this.isShowHorizontalBorder() ? bottom : 0);
                                break block0;
                            }
                            outRect.set(0, top, right, this.isShowHorizontalBorder() ? bottom : 0);
                            break block0;
                        }
                        case End: {
                            if (orientation == 1) {
                                outRect.set(left, this.isSingleRow(layoutManager) ? (this.isShowHorizontalBorder() ? top : 0) : 0, this.isShowVerticalBorder() ? right : 0, this.isShowHorizontalBorder() ? bottom : 0);
                                break block0;
                            }
                            outRect.set(this.isSingleColumn(layoutManager) ? (this.isShowVerticalBorder() ? left : 0) : 0, top, this.isShowVerticalBorder() ? right : 0, this.isShowHorizontalBorder() ? bottom : 0);
                        }
                    }
                }
            }
            this.rtlCompat(parent.getLayoutManager(), outRect);
            this.reverseCompat(parent.getLayoutManager(), outRect);
        }
    }
}

