/*
 * Decompiled with CFR 0.152.
 */
package com.passerby.recyclerviewlib.recycler.decoration;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.passerby.recyclerviewlib.recycler.decoration.BaseItemDecoration;
import com.passerby.recyclerviewlib.recycler.decoration.Direction;
import com.passerby.recyclerviewlib.recycler.decoration.DividerStyle;
import com.passerby.recyclerviewlib.recycler.decoration.Gravity;

public class LinearItemDecoration
extends BaseItemDecoration {
    private boolean isShowVerticalLeftBorder;
    private boolean isShowHorizontalTopBorder;
    private boolean isShowVerticalRightBorder;
    private boolean isShowHorizontalBottomBorder;

    public LinearItemDecoration() {
    }

    public LinearItemDecoration(int spacingWidth, int spacingHeight) {
        super(spacingWidth, spacingHeight);
    }

    @Override
    public void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager == null || this.dividerColor == null && this.dividerDrawable == null && this.onCustomDrawDividerCallback == null) {
            return;
        }
        if (this.isSingle(layoutManager) || this.isSingleRow(layoutManager) || this.isSingleColumn(layoutManager)) {
            this.onDrawDivider(canvas, parent);
        }
    }

    @Override
    protected void drawViewLeft(RecyclerView parent, Canvas canvas, Gravity verticalGravity, Gravity horizontalGravity, int left, int top, int right, int bottom) {
        if (this.spacingWidth == 0 && this.getDivider().getVerticalWidth() == 0) {
            return;
        }
        if (!this.isVerticalOrientation(parent.getLayoutManager()) ? !this.getDivider().isDrawLeftBorderDivide() && horizontalGravity == Gravity.Start : !this.getDivider().isDrawLeftBorderDivide()) {
            return;
        }
        this.drawDivider(parent, canvas, verticalGravity, horizontalGravity, Direction.LEFT, left, top, right, bottom);
    }

    @Override
    protected void drawViewRight(RecyclerView parent, Canvas canvas, Gravity verticalGravity, Gravity horizontalGravity, int left, int top, int right, int bottom) {
        if (this.spacingWidth == 0 && this.getDivider().getVerticalWidth() == 0) {
            return;
        }
        if (!this.isVerticalOrientation(parent.getLayoutManager()) ? (!this.isShowVerticalLeftBorder || !this.getDivider().isDrawRightBorderDivide()) && horizontalGravity == Gravity.End : !this.isShowVerticalLeftBorder || !this.getDivider().isDrawRightBorderDivide()) {
            return;
        }
        this.drawDivider(parent, canvas, verticalGravity, horizontalGravity, Direction.RIGHT, left, top, right, bottom);
    }

    @Override
    protected void drawViewTop(RecyclerView parent, Canvas canvas, Gravity verticalGravity, Gravity horizontalGravity, int left, int top, int right, int bottom) {
        if (this.spacingHeight == 0 && this.getDivider().getHorizontalHeight() == 0) {
            return;
        }
        if (this.isVerticalOrientation(parent.getLayoutManager()) && verticalGravity != Gravity.Start) {
            return;
        }
        if (!this.isShowHorizontalTopBorder || !this.getDivider().isDrawTopBorderDivide()) {
            return;
        }
        this.drawDivider(parent, canvas, verticalGravity, horizontalGravity, Direction.TOP, left, top, right, bottom);
    }

    @Override
    protected void drawViewBottom(RecyclerView parent, Canvas canvas, Gravity verticalGravity, Gravity horizontalGravity, int left, int top, int right, int bottom) {
        if (this.spacingHeight == 0 && this.getDivider().getHorizontalHeight() == 0) {
            return;
        }
        if (this.isVerticalOrientation(parent.getLayoutManager()) ? (!this.isShowHorizontalBottomBorder || !this.getDivider().isDrawBottomBorderDivide()) && verticalGravity == Gravity.End : !this.isShowHorizontalBottomBorder || !this.getDivider().isDrawBottomBorderDivide()) {
            return;
        }
        this.drawDivider(parent, canvas, verticalGravity, horizontalGravity, Direction.BOTTOM, left, top, right, bottom);
    }

    @Override
    protected Rect measureDividerRect(RecyclerView parent, DividerStyle style, Rect dividerRect, Gravity verticalGravity, Gravity horizontalGravity, Direction direction, int left, int top, int right, int bottom) {
        boolean isVertical = this.isVerticalOrientation(parent.getLayoutManager());
        switch (direction) {
            case LEFT: 
            case RIGHT: {
                dividerRect.top = top;
                dividerRect.bottom = bottom;
                if (verticalGravity != Gravity.Single && horizontalGravity != Gravity.Single) {
                    if (right - left <= style.getVerticalWidth()) {
                        dividerRect.left = left;
                        dividerRect.right = left + style.getVerticalWidth();
                        if (this.spacingHeight > style.getHorizontalHeight()) {
                            dividerRect.top += this.spacingHeight / 2 - style.getHorizontalHeight() / 2;
                            dividerRect.bottom -= this.spacingHeight / 2 - style.getHorizontalHeight() / 2;
                        }
                    } else if (style.getGravity() == Gravity.Start) {
                        dividerRect.left = left;
                        dividerRect.right = left + style.getVerticalWidth();
                        dividerRect.bottom -= this.spacingHeight - style.getHorizontalHeight();
                    } else if (style.getGravity() == Gravity.Center) {
                        dividerRect.left = left + Math.round((float)(right - left - style.getVerticalWidth()) / 2.0f);
                        dividerRect.right = dividerRect.left + style.getVerticalWidth();
                        if (this.spacingHeight > style.getHorizontalHeight()) {
                            dividerRect.top += this.spacingHeight / 2 - style.getHorizontalHeight() / 2;
                            dividerRect.bottom -= this.spacingHeight / 2 - style.getHorizontalHeight() / 2;
                        }
                    } else if (style.getGravity() == Gravity.End) {
                        dividerRect.left = right - style.getVerticalWidth();
                        dividerRect.right = right;
                        dividerRect.top += this.spacingHeight;
                    }
                }
                if (!isVertical || verticalGravity == Gravity.Start) {
                    if (!this.isShowHorizontalTopBorder || !style.isDrawTopBorderDivide() || style.getHorizontalHeight() == 0) {
                        dividerRect.top = top;
                        dividerRect.top += Math.max(this.spacingHeight, style.getHorizontalHeight());
                    }
                    dividerRect.top += style.getVerticalTopPadding();
                }
                if (isVertical && verticalGravity != Gravity.End) break;
                if (!this.isShowHorizontalBottomBorder || !style.isDrawBottomBorderDivide() || style.getHorizontalHeight() == 0) {
                    dividerRect.bottom = bottom;
                    dividerRect.bottom -= Math.max(this.spacingHeight, style.getHorizontalHeight());
                }
                dividerRect.bottom -= style.getVerticalBottomPadding();
                break;
            }
            case TOP: 
            case BOTTOM: {
                dividerRect.left = left;
                dividerRect.right = right;
                if (verticalGravity != Gravity.Single && horizontalGravity != Gravity.Single) {
                    if (bottom - top <= style.getHorizontalHeight()) {
                        dividerRect.top = top;
                        dividerRect.bottom = top + style.getHorizontalHeight();
                        if (this.spacingWidth > style.getVerticalWidth()) {
                            dividerRect.left += this.spacingWidth / 2 - style.getVerticalWidth() / 2;
                            dividerRect.right -= this.spacingWidth / 2 - style.getVerticalWidth() / 2;
                        }
                    } else if (style.getGravity() == Gravity.Start) {
                        dividerRect.top = top;
                        dividerRect.bottom = top + style.getHorizontalHeight();
                        dividerRect.right -= this.spacingWidth - style.getVerticalWidth();
                    } else if (style.getGravity() == Gravity.Center) {
                        dividerRect.top = top + Math.round((float)(bottom - top - style.getHorizontalHeight()) / 2.0f);
                        dividerRect.bottom = dividerRect.top + style.getHorizontalHeight();
                        if (this.spacingWidth > style.getVerticalWidth()) {
                            dividerRect.left += this.spacingWidth / 2 - style.getVerticalWidth() / 2;
                            dividerRect.right -= this.spacingWidth / 2 - style.getVerticalWidth() / 2;
                        }
                    } else if (style.getGravity() == Gravity.End) {
                        dividerRect.top = bottom - style.getHorizontalHeight();
                        dividerRect.bottom = bottom;
                        dividerRect.left += this.spacingWidth;
                    }
                }
                if (isVertical || horizontalGravity == Gravity.Start) {
                    if (!this.isShowVerticalLeftBorder || !style.isDrawLeftBorderDivide() || style.getVerticalWidth() == 0) {
                        dividerRect.left = left;
                        dividerRect.left += Math.max(this.spacingWidth, style.getVerticalWidth());
                    }
                    dividerRect.left += style.getHorizontalLeftPadding();
                }
                if (!isVertical && horizontalGravity != Gravity.End) break;
                if (!this.isShowVerticalRightBorder || !style.isDrawRightBorderDivide() || style.getVerticalWidth() == 0) {
                    dividerRect.right = right;
                    dividerRect.right -= Math.max(this.spacingWidth, style.getVerticalWidth());
                }
                dividerRect.right -= style.getHorizontalRightPadding();
            }
        }
        this.rtlCompat(parent.getLayoutManager(), dividerRect);
        this.reverseCompat(parent.getLayoutManager(), dividerRect);
        return dividerRect;
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager == null) {
            super.getItemOffsets(outRect, view, parent, state);
            return;
        }
        if (this.isSingle(layoutManager) || this.isSingleRow(layoutManager) || this.isSingleColumn(layoutManager)) {
            this.measureItemOffsets(outRect, view, parent, layoutManager, state);
        } else {
            super.getItemOffsets(outRect, view, parent, state);
        }
    }

    protected void measureItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.LayoutManager layoutManager, RecyclerView.State state) {
        RecyclerView.ViewHolder holder = parent.getChildViewHolder(view);
        int position = holder.getAbsoluteAdapterPosition();
        int orientation = this.getOrientation(layoutManager);
        int spacingWidth = Math.max(this.spacingWidth, this.getDivider() != null ? this.getDivider().getVerticalWidth() : 0);
        int spacingHeight = Math.max(this.spacingHeight, this.getDivider() != null ? this.getDivider().getHorizontalHeight() : 0);
        if (this.isSingle(layoutManager)) {
            outRect.set(this.isShowVerticalLeftBorder ? spacingWidth : 0, this.isShowHorizontalTopBorder ? spacingHeight : 0, this.isShowVerticalRightBorder ? spacingWidth : 0, this.isShowHorizontalBottomBorder ? spacingHeight : 0);
        } else if (orientation == 1) {
            switch (this.getVerticalGravity(parent, layoutManager, holder, position)) {
                case Start: {
                    outRect.set(this.isShowVerticalLeftBorder ? spacingWidth : 0, this.isShowHorizontalTopBorder ? spacingHeight : 0, this.isShowVerticalRightBorder ? spacingWidth : 0, 0);
                    break;
                }
                case Center: {
                    outRect.set(this.isShowVerticalLeftBorder ? spacingWidth : 0, spacingHeight, this.isShowVerticalRightBorder ? spacingWidth : 0, 0);
                    break;
                }
                case End: {
                    outRect.set(this.isShowVerticalLeftBorder ? spacingWidth : 0, spacingHeight, this.isShowVerticalRightBorder ? spacingWidth : 0, this.isShowHorizontalBottomBorder ? spacingHeight : 0);
                }
            }
        } else {
            switch (this.getHorizontalGravity(parent, layoutManager, holder, position)) {
                case Start: {
                    outRect.set(this.isShowVerticalLeftBorder ? spacingWidth : 0, this.isShowHorizontalTopBorder ? spacingHeight : 0, 0, this.isShowHorizontalBottomBorder ? spacingHeight : 0);
                    break;
                }
                case Center: {
                    outRect.set(spacingWidth, this.isShowHorizontalTopBorder ? spacingHeight : 0, 0, this.isShowHorizontalBottomBorder ? spacingHeight : 0);
                    break;
                }
                case End: {
                    outRect.set(spacingWidth, this.isShowHorizontalTopBorder ? spacingHeight : 0, this.isShowVerticalRightBorder ? spacingWidth : 0, this.isShowHorizontalBottomBorder ? spacingHeight : 0);
                }
            }
        }
        this.rtlCompat(parent.getLayoutManager(), outRect);
        this.reverseCompat(parent.getLayoutManager(), outRect);
    }

    public void setShowVerticalLeftBorder(boolean showVerticalLeftBorder) {
        this.isShowVerticalLeftBorder = showVerticalLeftBorder;
        super.setShowVerticalBorder(this.isShowVerticalLeftBorder && this.isShowVerticalRightBorder);
    }

    public void setShowHorizontalTopBorder(boolean showHorizontalTopBorder) {
        this.isShowHorizontalTopBorder = showHorizontalTopBorder;
        super.setShowVerticalBorder(this.isShowHorizontalTopBorder && this.isShowHorizontalBottomBorder);
    }

    public void setShowVerticalRightBorder(boolean showVerticalRightBorder) {
        this.isShowVerticalRightBorder = showVerticalRightBorder;
        super.setShowVerticalBorder(this.isShowVerticalLeftBorder && this.isShowVerticalRightBorder);
    }

    public void setShowHorizontalBottomBorder(boolean showHorizontalBottomBorder) {
        this.isShowHorizontalBottomBorder = showHorizontalBottomBorder;
        super.setShowVerticalBorder(this.isShowHorizontalTopBorder && this.isShowHorizontalBottomBorder);
    }

    public boolean isShowVerticalLeftBorder() {
        return this.isShowVerticalLeftBorder;
    }

    public boolean isShowHorizontalTopBorder() {
        return this.isShowHorizontalTopBorder;
    }

    public boolean isShowVerticalRightBorder() {
        return this.isShowVerticalRightBorder;
    }

    public boolean isShowHorizontalBottomBorder() {
        return this.isShowHorizontalBottomBorder;
    }

    @Override
    public void setShowVerticalBorder(boolean isShow) {
        this.isShowVerticalLeftBorder = isShow;
        this.isShowVerticalRightBorder = isShow;
        super.setShowVerticalBorder(isShow);
    }

    @Override
    public void setShowHorizontalBorder(boolean isShow) {
        this.isShowHorizontalTopBorder = isShow;
        this.isShowHorizontalBottomBorder = isShow;
        super.setShowHorizontalBorder(isShow);
    }
}

