package io.goeasy;

import io.goeasy.otp.OtpGenerator;
import io.goeasy.publish.PublishListener;
import io.goeasy.publish.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/**
 * @author Chuanbao
 */
public class GoEasy {
    private static Logger log = LoggerFactory.getLogger(Publisher.class);
    public static String artifactVersion="0.0";

    static {
        try {
            Class clazz = Publisher.class;
            String className = clazz.getSimpleName() + ".class";
            String classPath = clazz.getResource(className).toString();
            if (classPath.startsWith("jar")) {
                String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) +
                        "/META-INF/MANIFEST.MF";
                Manifest manifest = new Manifest(new URL(manifestPath).openStream());
                Attributes attr = manifest.getMainAttributes();
                String goeasyVersion = attr.getValue("goeasy-sdk-artifact-version");
                if(goeasyVersion != null){
                    artifactVersion = goeasyVersion;
                }
            }
        } catch (Exception e) {
            log.error("load artifact version failed.",e);
        }
    }

    private Publisher publisher;

    public GoEasy(String regionHost, String appkey) {
        publisher = new Publisher(regionHost, appkey);
    }

    public void publish(String channel,String content){
        publish(channel, content, new PublishListener());
    }

    public void publish(String messageId, String channel,String content){
        publish(messageId, channel, content, new PublishListener());
    }

    public void publish(String channel,String content,PublishListener publishListener){
        publish(null, channel,content,false,publishListener);
    }

    public void publish(String messageId, String channel,String content,PublishListener publishListener){
        publish(messageId, channel,content,false,publishListener);
    }

    public void publish(String channel,String content,boolean retained){
        publish(null, channel,content,retained,new PublishListener());
    }

    public void publish(String messageId, String channel,String content,boolean retained){
        publish(messageId, channel,content,retained,new PublishListener());
    }

    public void publish(String messgageId, String channel,String content,boolean retained,PublishListener publishListener){
        publisher.publish(messgageId, channel,content,retained,publishListener);
    }

    public void publish(String channel, String content, String notificationTitle, String notificationBody){
        publish(null, channel, content, notificationTitle, notificationBody);
    }

    public void publish(String channel, String content, String notificationTitle, String notificationBody, PublishListener publishListener){
        publish(null, channel, content, notificationTitle, notificationBody, publishListener);
    }

    public void publish(String messageId, String channel, String content, String notificationTitle, String notificationBody){
        publish(messageId, channel, content, notificationTitle, notificationBody, new PublishListener());
    }

    public void publish(String messageId, String channel, String content, String notificationTitle, String notificationBody, PublishListener publishListener){
        publisher.publish(messageId, channel, content, notificationTitle, notificationBody, publishListener);
    }
    public void setHttps(boolean https){
        publisher.setHttps(https);
    }

    public void setHost(String host){
        publisher.setPublisUrl(host + "/goeasy/publish");
    }

    public static String otp(String secretKey){
        return OtpGenerator.generate(secretKey);
    }
}
