package io.goeasy.otp;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

/**
 * @author Chuanbao
 */
public class OtpGenerator {
    private static Logger log = LoggerFactory.getLogger(OtpGenerator.class);

    public static String generate(String secretKey) {
        long millis = System.currentTimeMillis();
        String content = "000"+millis;
        try {
            SecretKeySpec key = new SecretKeySpec(secretKey.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            byte[] byteContent = content.getBytes();
            cipher.init(Cipher.ENCRYPT_MODE, key);
            byte[] bytes = cipher.doFinal(byteContent);
            return new BASE64Encoder().encode(bytes);
        } catch (Exception e) {
            log.error("Encrypt content:{} failed with secretKey:{}", content, secretKey, e);
            throw new IllegalArgumentException("Encrypt failed");
        }
    }
}
