package io.goeasy.presence;

import io.goeasy.manager.RestAccessManager;
import io.goeasy.manager.RestGetAccessManager;
import io.goeasy.publish.GoEasyError;
import io.goeasy.publish.GoEasyErrorCode;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Chuanbao
 */
public class PresenceFetcher {
    private RestAccessManager restAccessManager;

    public PresenceFetcher(String regionHost, String appkey) {
        boolean hasProtocol = regionHost.startsWith("http");
        if(!hasProtocol){
            regionHost = "http://"+regionHost;
        }
        String url = regionHost+"/presence";
        restAccessManager = new RestGetAccessManager(appkey, url);
    }

    public void fetch(List<String> channels, boolean includeUsers, boolean distinct, PresenceListener presenceListener) {
        if(channels==null || channels.isEmpty()){
            presenceListener.onFailed(new GoEasyError(GoEasyErrorCode.PARAMETER_ERROR.code(), "Channel is required"));
            return;
        }
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("channel", channels);
        params.put("includeUsers", includeUsers);
        params.put("distinct", distinct);
        restAccessManager.execute(params, presenceListener);
    }

    public void setHttps(boolean https) {
        if(https){
            restAccessManager.setHttps();
        }
    }
}
