package io.goeasy.publish;

/**
 * @author Chuanbao
 */
public enum GoEasyErrorCode {
    PARAMETER_ERROR(400,"Parameter Error"),
    UNAUTHORIZED(401,"Unauthorized"),
    UNREACHABLE_TIMEOUT(408,"Unreachable or timeout"),
    SERVER_ERROR(500,"Internal Server Error"),
    UNKNOWN_ERROR(10000,"Unknown Error");

    private int code;
    private String content;

    GoEasyErrorCode(int code, String content) {
        this.code = code;
        this.content = content;
    }

    public int code() {
        return code;
    }

    public String content() {
        return content;
    }
}
