/*
 * Decompiled with CFR 0.152.
 */
package io.grisu.usvcs.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import io.grisu.core.exceptions.GrisuException;
import io.grisu.pojo.utils.JSONUtils;
import io.grisu.usvcs.Client;
import io.grisu.usvcs.rabbitmq.RPCUtils;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClientRabbitMQ
implements Client {
    private final Channel channel;
    private final String replyQueueName;
    private final Map<String, Object[]> listeners;
    private final AtomicBoolean running;
    private final Consumer consumer;
    private String consumerTag;

    public ClientRabbitMQ(Channel channel) throws IOException {
        this.channel = channel;
        this.replyQueueName = channel.queueDeclare("reply_" + UUID.randomUUID().toString(), true, true, true, null).getQueue();
        this.listeners = new ConcurrentHashMap<String, Object[]>();
        this.running = new AtomicBoolean(false);
        this.consumer = new DefaultConsumer(channel){

            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
                Object[] entry = (Object[])ClientRabbitMQ.this.listeners.remove(properties.getCorrelationId());
                if (entry != null) {
                    CompletableFuture listener = (CompletableFuture)entry[1];
                    Object[] objects = RPCUtils.decodeMessage(body);
                    if ("KO".equals(objects[0])) {
                        listener.completeExceptionally((Throwable)GrisuException.build((Map)((Map)JSONUtils.decode((byte[])((byte[])objects[1]), Map.class))));
                    } else {
                        try {
                            Object ret = JSONUtils.decode((byte[])((byte[])objects[1]), (Type)((ParameterizedType)entry[0]).getActualTypeArguments()[0]);
                            listener.complete(ret);
                        }
                        catch (RuntimeException e) {
                            listener.completeExceptionally(e);
                        }
                    }
                }
            }
        };
    }

    public void start() {
        if (this.running.get()) {
            return;
        }
        this.running.set(true);
        try {
            this.consumerTag = this.channel.basicConsume(this.replyQueueName, true, this.consumer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        if (this.consumerTag != null) {
            try {
                this.channel.basicCancel(this.consumerTag);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public <R> CompletableFuture<R> send(String uServiceQueue, String nServiceIdentifier, Type returnType, Object ... params) {
        String correlationId = UUID.randomUUID().toString();
        AMQP.BasicProperties props = new AMQP.BasicProperties.Builder().correlationId(correlationId).replyTo(this.replyQueueName).build();
        CompletableFuture future = new CompletableFuture();
        this.listeners.put(correlationId, new Object[]{returnType, future});
        try {
            this.channel.basicPublish("", uServiceQueue, props, RPCUtils.encodeMessage(nServiceIdentifier, JSONUtils.encode((Object)params)));
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }
}

