/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.grpc.Context;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.Status;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Future;

final class ServerCallImpl<ReqT, RespT>
extends ServerCall<RespT> {
    private final ServerStream stream;
    private final MethodDescriptor<ReqT, RespT> method;
    private final Context.CancellableContext context;
    private volatile boolean cancelled;
    private boolean sendHeadersCalled;
    private boolean closeCalled;

    ServerCallImpl(ServerStream stream, MethodDescriptor<ReqT, RespT> method, Context.CancellableContext context) {
        this.stream = stream;
        this.method = method;
        this.context = context;
    }

    @Override
    public void request(int numMessages) {
        this.stream.request(numMessages);
    }

    @Override
    public void sendHeaders(Metadata headers) {
        Preconditions.checkState((!this.sendHeadersCalled ? 1 : 0) != 0, (Object)"sendHeaders has already been called");
        Preconditions.checkState((!this.closeCalled ? 1 : 0) != 0, (Object)"call is closed");
        this.sendHeadersCalled = true;
        this.stream.writeHeaders(headers);
    }

    @Override
    public void sendMessage(RespT message) {
        Preconditions.checkState((boolean)this.sendHeadersCalled, (Object)"sendHeaders has not been called");
        Preconditions.checkState((!this.closeCalled ? 1 : 0) != 0, (Object)"call is closed");
        try {
            InputStream resp = this.method.streamResponse(message);
            this.stream.writeMessage(resp);
            this.stream.flush();
        }
        catch (Throwable t) {
            this.close(Status.fromThrowable(t), new Metadata());
            throw Throwables.propagate((Throwable)t);
        }
    }

    @Override
    public void setMessageCompression(boolean enable) {
        this.stream.setMessageCompression(enable);
    }

    @Override
    public boolean isReady() {
        return this.stream.isReady();
    }

    @Override
    public void close(Status status, Metadata trailers) {
        block5: {
            block4: {
                try {
                    Preconditions.checkState((!this.closeCalled ? 1 : 0) != 0, (Object)"call already closed");
                    this.closeCalled = true;
                    this.stream.close(status, trailers);
                    if (status.getCode() != Status.Code.OK) break block4;
                    this.context.cancel(null);
                }
                catch (Throwable throwable) {
                    if (status.getCode() == Status.Code.OK) {
                        this.context.cancel(null);
                    } else {
                        this.context.cancel(status.getCause() != null ? status.getCause() : status.asRuntimeException());
                    }
                    throw throwable;
                }
                break block5;
            }
            this.context.cancel(status.getCause() != null ? status.getCause() : status.asRuntimeException());
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    ServerStreamListener newServerStreamListener(ServerCall.Listener<ReqT> listener, Future<?> timeout) {
        return new ServerStreamListenerImpl<ReqT>(this, listener, timeout);
    }

    @VisibleForTesting
    static final class ServerStreamListenerImpl<ReqT>
    implements ServerStreamListener {
        private final ServerCallImpl<ReqT, ?> call;
        private final ServerCall.Listener<ReqT> listener;
        private final Future<?> timeout;
        private boolean messageReceived;

        public ServerStreamListenerImpl(ServerCallImpl<ReqT, ?> call, ServerCall.Listener<ReqT> listener, Future<?> timeout) {
            this.call = (ServerCallImpl)Preconditions.checkNotNull(call, (Object)"call");
            this.listener = (ServerCall.Listener)Preconditions.checkNotNull(listener, (Object)"listener must not be null");
            this.timeout = (Future)Preconditions.checkNotNull(timeout, (Object)"timeout");
        }

        @Override
        public void messageRead(InputStream message) {
            try {
                if (((ServerCallImpl)this.call).cancelled) {
                    return;
                }
                if (this.messageReceived && ((ServerCallImpl)this.call).method.getType() == MethodDescriptor.MethodType.UNARY) {
                    ((ServerCallImpl)this.call).stream.close(Status.INVALID_ARGUMENT.withDescription("More than one request messages for unary call or server streaming call"), new Metadata());
                    return;
                }
                this.messageReceived = true;
                this.listener.onMessage(((ServerCallImpl)this.call).method.parseRequest(message));
            }
            finally {
                try {
                    message.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void halfClosed() {
            if (((ServerCallImpl)this.call).cancelled) {
                return;
            }
            this.listener.onHalfClose();
        }

        @Override
        public void closed(Status status) {
            this.timeout.cancel(true);
            if (status.isOk()) {
                this.listener.onComplete();
            } else {
                ((ServerCallImpl)this.call).cancelled = true;
                this.listener.onCancel();
            }
        }

        @Override
        public void onReady() {
            if (((ServerCallImpl)this.call).cancelled) {
                return;
            }
            this.listener.onReady();
        }
    }
}

