/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import io.grpc.netty.GoAwayClosedStreamException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DecoratingHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;

class BufferingHttp2ConnectionEncoder
extends DecoratingHttp2ConnectionEncoder {
    static final int SMALLEST_MAX_CONCURRENT_STREAMS = 100;
    private final TreeMap<Integer, PendingStream> pendingStreams = new TreeMap();
    private final int initialMaxConcurrentStreams;
    private int largestCreatedStreamId;
    private boolean receivedSettings;

    protected BufferingHttp2ConnectionEncoder(Http2ConnectionEncoder delegate) {
        this(delegate, 100);
    }

    protected BufferingHttp2ConnectionEncoder(Http2ConnectionEncoder delegate, int initialMaxConcurrentStreams) {
        super(delegate);
        this.initialMaxConcurrentStreams = initialMaxConcurrentStreams;
        this.connection().addListener((Http2Connection.Listener)new Http2ConnectionAdapter(){

            public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
                BufferingHttp2ConnectionEncoder.this.cancelGoAwayStreams(lastStreamId, errorCode, debugData);
            }

            public void onStreamClosed(Http2Stream stream) {
                BufferingHttp2ConnectionEncoder.this.tryCreatePendingStreams();
            }
        });
    }

    public int numBufferedStreams() {
        return this.pendingStreams.size();
    }

    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream, ChannelPromise promise) {
        return this.writeHeaders(ctx, streamId, headers, 0, (short)16, false, padding, endStream, promise);
    }

    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream, ChannelPromise promise) {
        if (this.existingStream(streamId) || this.connection().goAwayReceived()) {
            return super.writeHeaders(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endOfStream, promise);
        }
        if (this.canCreateStream()) {
            assert (streamId > this.largestCreatedStreamId);
            this.largestCreatedStreamId = streamId;
            return super.writeHeaders(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endOfStream, promise);
        }
        PendingStream pendingStream = this.pendingStreams.get(streamId);
        if (pendingStream == null) {
            pendingStream = new PendingStream(ctx, streamId);
            this.pendingStreams.put(streamId, pendingStream);
        }
        pendingStream.frames.add(new HeadersFrame(headers, streamDependency, weight, exclusive, padding, endOfStream, promise));
        return promise;
    }

    public ChannelFuture writeRstStream(ChannelHandlerContext ctx, int streamId, long errorCode, ChannelPromise promise) {
        if (this.existingStream(streamId)) {
            return super.writeRstStream(ctx, streamId, errorCode, promise);
        }
        PendingStream stream = this.pendingStreams.remove(streamId);
        if (stream != null) {
            stream.close(null);
            promise.setSuccess();
        } else {
            promise.setFailure((Throwable)Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Stream does not exist %d", (Object[])new Object[]{streamId}));
        }
        return promise;
    }

    public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream, ChannelPromise promise) {
        if (this.existingStream(streamId)) {
            return super.writeData(ctx, streamId, data, padding, endOfStream, promise);
        }
        PendingStream pendingStream = this.pendingStreams.get(streamId);
        if (pendingStream != null) {
            pendingStream.frames.add(new DataFrame(data, padding, endOfStream, promise));
        } else {
            ReferenceCountUtil.safeRelease((Object)data);
            promise.setFailure((Throwable)Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Stream does not exist %d", (Object[])new Object[]{streamId}));
        }
        return promise;
    }

    public ChannelFuture writeSettingsAck(ChannelHandlerContext ctx, ChannelPromise promise) {
        this.receivedSettings = true;
        ChannelFuture future = super.writeSettingsAck(ctx, promise);
        this.tryCreatePendingStreams();
        return future;
    }

    public void close() {
        super.close();
        this.cancelPendingStreams();
    }

    private void tryCreatePendingStreams() {
        while (!this.pendingStreams.isEmpty() && this.canCreateStream()) {
            Map.Entry<Integer, PendingStream> entry = this.pendingStreams.pollFirstEntry();
            PendingStream pendingStream = entry.getValue();
            pendingStream.sendFrames();
            this.largestCreatedStreamId = pendingStream.streamId;
        }
    }

    private void cancelPendingStreams() {
        Exception e = new Exception("Connection closed.");
        while (!this.pendingStreams.isEmpty()) {
            PendingStream stream = this.pendingStreams.pollFirstEntry().getValue();
            stream.close(e);
        }
    }

    private void cancelGoAwayStreams(int lastStreamId, long errorCode, ByteBuf debugData) {
        Iterator<PendingStream> iter = this.pendingStreams.values().iterator();
        GoAwayClosedStreamException e = new GoAwayClosedStreamException(lastStreamId, errorCode, debugData);
        while (iter.hasNext()) {
            PendingStream stream = iter.next();
            if (stream.streamId <= lastStreamId) continue;
            iter.remove();
            stream.close(e);
        }
    }

    private boolean canCreateStream() {
        Http2Connection.Endpoint local = this.connection().local();
        return (this.receivedSettings || local.numActiveStreams() < this.initialMaxConcurrentStreams) && local.canCreateStream();
    }

    private boolean existingStream(int streamId) {
        return streamId <= this.largestCreatedStreamId;
    }

    private class DataFrame
    extends Frame {
        final ByteBuf data;
        final int padding;
        final boolean endOfStream;

        DataFrame(ByteBuf data, int padding, boolean endOfStream, ChannelPromise promise) {
            super(promise);
            this.data = data;
            this.padding = padding;
            this.endOfStream = endOfStream;
        }

        @Override
        public void release(Throwable t) {
            super.release(t);
            ReferenceCountUtil.safeRelease((Object)this.data);
        }

        @Override
        void send(ChannelHandlerContext ctx, int streamId) {
            BufferingHttp2ConnectionEncoder.this.writeData(ctx, streamId, this.data, this.padding, this.endOfStream, this.promise);
        }
    }

    private class HeadersFrame
    extends Frame {
        final Http2Headers headers;
        final int streamDependency;
        final short weight;
        final boolean exclusive;
        final int padding;
        final boolean endOfStream;

        HeadersFrame(Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream, ChannelPromise promise) {
            super(promise);
            this.headers = headers;
            this.streamDependency = streamDependency;
            this.weight = weight;
            this.exclusive = exclusive;
            this.padding = padding;
            this.endOfStream = endOfStream;
        }

        @Override
        void send(ChannelHandlerContext ctx, int streamId) {
            BufferingHttp2ConnectionEncoder.this.writeHeaders(ctx, streamId, this.headers, this.streamDependency, this.weight, this.exclusive, this.padding, this.endOfStream, this.promise);
        }
    }

    private static abstract class Frame {
        final ChannelPromise promise;

        Frame(ChannelPromise promise) {
            this.promise = promise;
        }

        void release(Throwable t) {
            if (t == null) {
                this.promise.setSuccess();
            } else {
                this.promise.setFailure(t);
            }
        }

        abstract void send(ChannelHandlerContext var1, int var2);
    }

    private static class PendingStream {
        final ChannelHandlerContext ctx;
        final int streamId;
        final Queue<Frame> frames = new ArrayDeque<Frame>(2);

        PendingStream(ChannelHandlerContext ctx, int streamId) {
            this.ctx = ctx;
            this.streamId = streamId;
        }

        void sendFrames() {
            for (Frame frame : this.frames) {
                frame.send(this.ctx, this.streamId);
            }
        }

        void close(Throwable t) {
            for (Frame frame : this.frames) {
                frame.release(t);
            }
        }
    }
}

